/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.misc;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ProbabilityGroup {
    private List<ItemStack> outputs;
    private double probability;

    public ProbabilityGroup(List<ItemStack> outputs, double probability) {
        this.outputs = outputs;
        this.probability = probability;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public double getProbability() {
        return this.probability;
    }

    public JsonElement serialize() {
        JsonObject output = new JsonObject();
        output.add("probability", (JsonElement)new JsonPrimitive((Number)this.probability));
        JsonArray stacks = new JsonArray();
        for (ItemStack stack : this.outputs) {
            JsonObject temp = new JsonObject();
            temp.add("item", (JsonElement)new JsonPrimitive(stack.func_77973_b().getRegistryName().toString()));
            if (stack.func_190916_E() > 1) {
                temp.add("count", (JsonElement)new JsonPrimitive((Number)stack.func_190916_E()));
            }
            stacks.add((JsonElement)temp);
        }
        output.add("stacks", (JsonElement)stacks);
        return output;
    }

    public void write(PacketBuffer buf) {
        buf.writeInt(this.outputs.size());
        for (ItemStack stack : this.outputs) {
            buf.func_150788_a(stack);
        }
        buf.writeDouble(this.probability);
    }

    public static ProbabilityGroup read(PacketBuffer buf) {
        ArrayList stacks = Lists.newArrayList();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            stacks.add(buf.func_150791_c());
        }
        double probability = buf.readDouble();
        return new ProbabilityGroup(stacks, probability);
    }
}

