/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.fusion;

import al132.alchemistry.Config;
import al132.alchemistry.Ref;
import al132.alchemistry.blocks.AlchemistryBaseTile;
import al132.alchemistry.blocks.PowerStatus;
import al132.alchemistry.blocks.fusion.FusionContainer;
import al132.alchemistry.blocks.fusion.FusionControllerBlock;
import al132.alib.tiles.ABaseTile;
import al132.alib.tiles.CustomEnergyStorage;
import al132.alib.tiles.CustomStackHandler;
import al132.alib.tiles.EnergyTile;
import al132.chemlib.chemistry.ElementRegistry;
import al132.chemlib.items.ElementItem;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class FusionTile
extends AlchemistryBaseTile
implements EnergyTile {
    boolean isValidMultiblock = false;
    ItemStack recipeOutput = ItemStack.field_190927_a;
    private int checkMultiblockTicks = 0;
    protected int progressTicks = 0;
    IItemHandler leftInput;
    IItemHandler rightInput;
    boolean firstTick = true;

    public FusionTile() {
        super(Ref.fusionTile);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.firstTick) {
            this.refreshRecipe();
            this.firstTick = false;
        }
        ++this.checkMultiblockTicks;
        if (this.checkMultiblockTicks >= 20) {
            this.updateMultiblock();
            this.checkMultiblockTicks = 0;
        }
        boolean isActive = !this.getInput().getStackInSlot(0).func_190926_b() && !this.getInput().getStackInSlot(1).func_190926_b();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() != Ref.fusionController) {
            return;
        }
        PowerStatus currentStatus = (PowerStatus)((Object)state.func_177229_b(FusionControllerBlock.STATUS));
        if (this.isValidMultiblock) {
            if (isActive) {
                if (currentStatus != PowerStatus.ON) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a(FusionControllerBlock.STATUS, (Comparable)((Object)PowerStatus.ON)));
                }
            } else if (currentStatus != PowerStatus.STANDBY) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a(FusionControllerBlock.STATUS, (Comparable)((Object)PowerStatus.STANDBY)));
            }
        } else if (currentStatus != PowerStatus.OFF) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a(FusionControllerBlock.STATUS, (Comparable)((Object)PowerStatus.OFF)));
        }
        if (this.canProcess()) {
            this.process();
        }
        this.notifyGUIEvery(5);
    }

    public boolean canProcess() {
        ItemStack input0 = this.getInput().getStackInSlot(0);
        ItemStack input1 = this.getInput().getStackInSlot(1);
        ItemStack output0 = this.getOutput().getStackInSlot(0);
        return this.isValidMultiblock && !input0.func_190926_b() && !input1.func_190926_b() && !this.recipeOutput.func_190926_b() && (ItemStack.func_179545_c((ItemStack)output0, (ItemStack)this.recipeOutput) || output0.func_190926_b()) && output0.func_190916_E() + this.recipeOutput.func_190916_E() <= this.recipeOutput.func_77976_d() && this.energy.getEnergyStored() >= (Integer)Config.FUSION_ENERGY_PER_TICK.get();
    }

    public void process() {
        if (this.progressTicks < (Integer)Config.FUSION_TICKS_PER_OPERATION.get()) {
            ++this.progressTicks;
        } else {
            this.progressTicks = 0;
            this.getOutput().setOrIncrement(0, this.recipeOutput.func_77946_l());
            this.getInput().decrementSlot(0, 1);
            this.getInput().decrementSlot(1, 1);
        }
        this.energy.extractEnergy(((Integer)Config.FUSION_ENERGY_PER_TICK.get()).intValue(), false);
    }

    public void refreshRecipe() {
        int meta1;
        int meta0;
        ElementItem outputElement;
        Item item0 = this.getInput().getStackInSlot(0).func_77973_b();
        Item item1 = this.getInput().getStackInSlot(1).func_77973_b();
        this.recipeOutput = item0 instanceof ElementItem && item1 instanceof ElementItem ? ((outputElement = (ElementItem)ElementRegistry.elements.get((Object)((meta0 = ((Integer)ElementRegistry.elements.inverse().get((Object)item0)).intValue()) + (meta1 = ((Integer)ElementRegistry.elements.inverse().get((Object)item1)).intValue())))) != null ? new ItemStack((IItemProvider)outputElement) : ItemStack.field_190927_a) : ItemStack.field_190927_a;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.progressTicks = compound.func_74762_e("progressTicks");
        this.isValidMultiblock = compound.func_74767_n("isValidMultiblock");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("progressTicks", this.progressTicks);
        compound.func_74757_a("isValidMultiblock", this.isValidMultiblock);
        return super.func_189515_b(compound);
    }

    public void updateMultiblock() {
        this.isValidMultiblock = this.validateMultiblock();
    }

    private boolean containsCasing(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos).func_177230_c() == Ref.fusionCasing;
    }

    private boolean containsCore(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos).func_177230_c() == Ref.fusionCore;
    }

    private boolean containsFusionPart(BlockPos pos) {
        Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
        return block == Ref.fusionCasing || block == Ref.fusionCore || block == Ref.fusionController;
    }

    public boolean validateMultiblock() {
        Direction temp = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)FusionControllerBlock.FACING);
        if (temp == null) {
            return false;
        }
        Direction multiblockDirection = temp.func_176734_d();
        BiFunction<BlockPos, Integer, BlockPos> offsetUp = (pos, amt) -> pos.func_177967_a(Direction.UP, amt.intValue());
        BiFunction<BlockPos, Integer, BlockPos> offsetLeft = (pos, amt) -> pos.func_177967_a(multiblockDirection.func_176746_e(), amt.intValue());
        BiFunction<BlockPos, Integer, BlockPos> offsetRight = (pos, amt) -> pos.func_177967_a(multiblockDirection.func_176746_e(), -1 * amt);
        BiFunction<BlockPos, Integer, BlockPos> offsetBack = (pos, amt) -> pos.func_177967_a(multiblockDirection, amt.intValue());
        BiFunction<BlockPos, Integer, BlockPos> offsetDown = (pos, amt) -> pos.func_177967_a(Direction.DOWN, amt.intValue());
        BlockPos coreBottom = offsetBack.apply(this.field_174879_c, 3);
        coreBottom = offsetUp.apply(coreBottom, 1);
        BlockPos coreTop = offsetUp.apply(coreBottom, 2);
        boolean coreMatches = BlockPos.func_218281_b((BlockPos)coreBottom, (BlockPos)coreTop).allMatch(this::containsCore);
        BlockPos outsideCorner1 = offsetLeft.apply(this.field_174879_c, 3);
        BlockPos outsideCorner1Final = outsideCorner1 = offsetDown.apply(outsideCorner1, 1);
        BlockPos outsideCorner2 = offsetRight.apply(outsideCorner1, 6);
        outsideCorner2 = offsetUp.apply(outsideCorner2, 6);
        outsideCorner2 = offsetBack.apply(outsideCorner2, 6);
        long borderingParts = BlockPos.func_218281_b((BlockPos)outsideCorner1, (BlockPos)outsideCorner2).filter(it -> {
            int sharedAxes = 0;
            if (it.func_177958_n() == outsideCorner1Final.func_177958_n() || it.func_177958_n() == outsideCorner1Final.func_177958_n()) {
                ++sharedAxes;
            }
            if (it.func_177956_o() == outsideCorner1Final.func_177956_o() || it.func_177956_o() == outsideCorner1Final.func_177956_o()) {
                ++sharedAxes;
            }
            if (it.func_177952_p() == outsideCorner1Final.func_177952_p() || it.func_177952_p() == outsideCorner1Final.func_177952_p()) {
                ++sharedAxes;
            }
            return sharedAxes >= 1;
        }).filter(it -> !it.equals((Object)this.field_174879_c)).filter(this::containsFusionPart).count();
        BlockPos casingCorner1 = offsetLeft.apply(this.field_174879_c, 2);
        BlockPos casingCorner1Final = casingCorner1 = offsetBack.apply(casingCorner1, 1);
        BlockPos casingCorner2 = offsetRight.apply(casingCorner1, 4);
        casingCorner2 = offsetBack.apply(casingCorner2, 4);
        BlockPos casingCorner2Final = casingCorner2 = offsetUp.apply(casingCorner2, 4);
        boolean casingMatches = BlockPos.func_218281_b((BlockPos)casingCorner1, (BlockPos)casingCorner2).filter(it -> {
            int sharedAxes = 0;
            if (it.func_177958_n() == casingCorner1Final.func_177958_n() || it.func_177958_n() == casingCorner2Final.func_177958_n()) {
                ++sharedAxes;
            }
            if (it.func_177956_o() == casingCorner1Final.func_177956_o() || it.func_177956_o() == casingCorner2Final.func_177956_o()) {
                ++sharedAxes;
            }
            if (it.func_177952_p() == casingCorner1Final.func_177952_p() || it.func_177952_p() == casingCorner2Final.func_177952_p()) {
                ++sharedAxes;
            }
            return sharedAxes >= 1;
        }).allMatch(this::containsCasing);
        return casingMatches && coreMatches && borderingParts == 0L;
    }

    public CustomStackHandler initInput() {
        CustomStackHandler input = new CustomStackHandler((ABaseTile)this, 2){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof ElementItem;
            }

            public void onContentsChanged(int slot) {
                ((FusionTile)this.tile).refreshRecipe();
                super.onContentsChanged(slot);
            }
        };
        this.leftInput = new RangedWrapper((IItemHandlerModifiable)input, 0, 1);
        this.rightInput = new RangedWrapper((IItemHandlerModifiable)input, 1, 2);
        return input;
    }

    public CustomStackHandler initOutput() {
        return new CustomStackHandler((ABaseTile)this, 1){

            @Nonnull
            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }
        };
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInv, PlayerEntity player) {
        return new FusionContainer(i, this.field_145850_b, this.field_174879_c, playerInv, player);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.isValidMultiblock) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.field_145850_b != null) {
                Direction blockSide = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)FusionControllerBlock.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return LazyOptional.of(() -> ((FusionTile)this).getOutput()).cast();
                }
                if (side == blockSide.func_176746_e()) {
                    return LazyOptional.of(() -> this.leftInput).cast();
                }
                if (side == blockSide.func_176746_e().func_176746_e().func_176746_e()) {
                    return LazyOptional.of(() -> this.rightInput).cast();
                }
                return LazyOptional.of(() -> ((FusionTile)this).getOutput()).cast();
            }
            return super.getCapability(cap, side);
        }
        return LazyOptional.empty();
    }

    public IEnergyStorage initEnergy() {
        return new CustomEnergyStorage(((Integer)Config.FUSION_ENERGY_CAPACITY.get()).intValue());
    }

    public IEnergyStorage getEnergy() {
        return this.energy;
    }
}

