/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.dissolver;

import al132.alchemistry.blocks.dissolver.DissolverRecipe;
import al132.alchemistry.misc.ProbabilityGroup;
import al132.alchemistry.misc.ProbabilitySet;
import al132.alchemistry.misc.ProcessingRecipe;
import al132.alchemistry.utils.IngredientStack;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DissolverRecipeSerializer<T extends DissolverRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private IFactory<T> factory;

    public DissolverRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? JSONUtils.func_151214_t((JsonObject)json, (String)"input") : JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        Ingredient input = Ingredient.func_199802_a((JsonElement)jsonelement);
        int inputCount = JSONUtils.func_151204_g((JsonObject)json, (String)"inputCount") ? JSONUtils.func_151203_m((JsonObject)json, (String)"inputCount") : 1;
        JsonObject outputJson = JSONUtils.func_152754_s((JsonObject)json, (String)"output");
        int rolls = JSONUtils.func_151203_m((JsonObject)outputJson, (String)"rolls");
        boolean relativeProbability = JSONUtils.func_151212_i((JsonObject)outputJson, (String)"relativeProbability");
        ArrayList groups = Lists.newArrayList();
        JsonArray groupJSON = JSONUtils.func_151214_t((JsonObject)outputJson, (String)"groups");
        for (JsonElement e : groupJSON) {
            ArrayList outputs = Lists.newArrayList();
            JsonObject temp = e.getAsJsonObject();
            for (JsonElement stack : temp.getAsJsonArray("stacks")) {
                outputs.add(ShapedRecipe.func_199798_a((JsonObject)stack.getAsJsonObject()));
            }
            double probability = JSONUtils.func_151217_k((JsonObject)temp, (String)"probability");
            groups.add(new ProbabilityGroup(outputs, probability));
        }
        ProbabilitySet output = new ProbabilitySet(groups, relativeProbability, rolls);
        return (T)((DissolverRecipe)this.factory.create(recipeId, group, new IngredientStack(input, inputCount), output));
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        IngredientStack input = IngredientStack.read(buffer);
        ProbabilitySet output = ProbabilitySet.read(buffer);
        return (T)((DissolverRecipe)this.factory.create(recipeId, group, input, output));
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(((ProcessingRecipe)recipe).func_193358_e());
        ((DissolverRecipe)recipe).inputIngredient.write(buffer);
        ((DissolverRecipe)recipe).outputs.write(buffer);
    }

    public static interface IFactory<T extends ProcessingRecipe> {
        public T create(ResourceLocation var1, String var2, IngredientStack var3, ProbabilitySet var4);
    }
}

