/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.atomizer;

import al132.alchemistry.Config;
import al132.alchemistry.Ref;
import al132.alchemistry.blocks.AlchemistryBaseTile;
import al132.alchemistry.blocks.atomizer.AtomizerContainer;
import al132.alchemistry.blocks.atomizer.AtomizerRecipe;
import al132.alchemistry.blocks.atomizer.AtomizerRegistry;
import al132.alib.tiles.ABaseTile;
import al132.alib.tiles.CustomEnergyStorage;
import al132.alib.tiles.CustomStackHandler;
import al132.alib.tiles.EnergyTile;
import al132.alib.tiles.FluidTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class AtomizerTile
extends AlchemistryBaseTile
implements EnergyTile,
FluidTile {
    protected FluidTank inputTank;
    protected LazyOptional<IFluidHandler> fluidHolder = LazyOptional.of(() -> this.inputTank);
    private AtomizerRecipe currentRecipe = null;
    protected int progressTicks = 0;

    public AtomizerTile() {
        super(Ref.atomizerTile);
        this.inputTank = new FluidTank(10000){

            protected void onContentsChanged() {
                super.onContentsChanged();
                AtomizerTile.this.updateRecipe();
            }
        };
    }

    public void updateRecipe() {
        if (!(this.inputTank.isEmpty() || this.currentRecipe != null && ItemStack.func_77989_b((ItemStack)this.currentRecipe.output, (ItemStack)this.getOutput().getStackInSlot(0)))) {
            this.currentRecipe = AtomizerRegistry.getRecipes(this.field_145850_b).stream().filter(it -> it.input.getFluid() == this.inputTank.getFluid().getFluid()).findFirst().orElse(null);
        }
        if (this.inputTank.isEmpty()) {
            this.currentRecipe = null;
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.inputTank.getFluidAmount() > 0) {
            this.updateRecipe();
            if (this.canProcess()) {
                this.process();
            }
        }
        this.notifyGUIEvery(5);
    }

    public boolean canProcess() {
        if (this.currentRecipe != null) {
            ItemStack recipeOutput = this.currentRecipe.output;
            ItemStack output0 = this.getOutput().getStackInSlot(0);
            return this.energy.getEnergyStored() >= (Integer)Config.LIQUIFIER_ENERGY_PER_TICK.get() && this.inputTank.getFluidAmount() >= this.currentRecipe.input.getAmount() && (ItemStack.func_179545_c((ItemStack)output0, (ItemStack)recipeOutput) || output0.func_190926_b()) && output0.func_190916_E() + recipeOutput.func_190916_E() <= recipeOutput.func_77976_d();
        }
        return false;
    }

    public void process() {
        if (this.progressTicks < (Integer)Config.LIQUIFIER_TICKS_PER_OPERATION.get()) {
            ++this.progressTicks;
        } else {
            this.progressTicks = 0;
            this.getOutput().setOrIncrement(0, this.currentRecipe.output.func_77946_l());
            this.inputTank.drain(this.currentRecipe.input.getAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.energy.extractEnergy(((Integer)Config.LIQUIFIER_ENERGY_PER_TICK.get()).intValue(), false);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.progressTicks = compound.func_74762_e("progressTicks");
        this.inputTank.readFromNBT(compound.func_74775_l("inputTank"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("progressTicks", this.progressTicks);
        compound.func_218657_a("inputTank", (INBT)this.inputTank.writeToNBT(new CompoundNBT()));
        return super.func_189515_b(compound);
    }

    public CustomStackHandler initInput() {
        return new CustomStackHandler((ABaseTile)this, 0);
    }

    public CustomStackHandler initOutput() {
        return new CustomStackHandler((ABaseTile)this, 1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }
        };
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInv, PlayerEntity player) {
        return new AtomizerContainer(i, this.field_145850_b, this.field_174879_c, playerInv, player);
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHolder;
    }

    public IEnergyStorage initEnergy() {
        return new CustomEnergyStorage(((Integer)Config.ATOMIZER_ENERGY_CAPACITY.get()).intValue());
    }

    public IEnergyStorage getEnergy() {
        return this.energy;
    }
}

