/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.base;

import de.melanx.aiotbotania.AIOTBotania;
import de.melanx.aiotbotania.items.livingrock.ItemLivingrockAIOT;
import de.melanx.aiotbotania.items.livingwood.ItemLivingwoodAIOT;
import de.melanx.aiotbotania.util.ToolUtil;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemAIOTBase
extends ToolItem
implements IManaUsingItem {
    protected final int MANA_PER_DAMAGE;
    protected final boolean special;
    protected final IItemTier mat;

    public ItemAIOTBase(IItemTier mat, float attackDamage, float attackSpeed, int MANA_PER_DAMAGE, boolean special) {
        super(attackDamage, attackSpeed, mat, new HashSet(), new Item.Properties().func_200916_a(AIOTBotania.instance.getTab()).addToolType(ToolType.AXE, mat.func_200925_d()).addToolType(ToolType.PICKAXE, mat.func_200925_d()).addToolType(ToolType.SHOVEL, mat.func_200925_d()).addToolType(ToolType.HOE, mat.func_200925_d()));
        this.MANA_PER_DAMAGE = MANA_PER_DAMAGE;
        this.special = special;
        this.mat = mat;
    }

    public static boolean getBindMode(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"hoemode", (boolean)true);
    }

    public static String getModeString(ItemStack stack) {
        Item tool = stack.func_77973_b();
        if (tool instanceof ItemLivingrockAIOT || tool instanceof ItemLivingwoodAIOT) {
            return "aiotbotania" + (ItemAIOTBase.getBindMode(stack) ? ".hoeMode" : ".utilityMode");
        }
        return "aiotbotania" + (ItemAIOTBase.getBindMode(stack) ? ".hoeModePath" : ".utilityMode");
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        ToolUtil.inventoryTick(stack, world, player, this.MANA_PER_DAMAGE);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return ToolCommons.damageItemIfPossible((ItemStack)stack, (int)amount, entity, (int)this.MANA_PER_DAMAGE);
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        Direction side = ctx.func_196000_l();
        if (player == null) {
            return ActionResultType.PASS;
        }
        boolean hoemode = ItemNBTHelper.getBoolean((ItemStack)stack, (String)"hoemode", (boolean)true);
        if (hoemode) {
            if (!player.func_213453_ef()) {
                return ToolUtil.hoeUse(ctx, this.special, false);
            }
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockReader)world, pos.func_177984_a())) {
                return ToolUtil.shovelUse(ctx);
            }
            return ToolUtil.stripLog(ctx);
        }
        if (!player.func_213453_ef()) {
            return ToolUtil.pickUse(ctx);
        }
        if (side == Direction.UP) {
            return ToolUtil.axeUse(ctx);
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_213453_ef()) {
            ToolUtil.toggleMode(player, itemStack);
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public float func_150893_a(@Nonnull ItemStack stack, BlockState state) {
        if (state.func_177230_c() == Blocks.field_196553_aF) {
            return 15.0f;
        }
        return state.func_177230_c().getHarvestTool(state) == null || this.getToolTypes(stack).contains(state.func_177230_c().getHarvestTool(state)) ? this.field_77864_a : 1.0f;
    }

    public boolean usesMana(ItemStack itemStack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y.func_77557_a(Items.field_151048_u);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, List<ITextComponent> list, @Nonnull ITooltipFlag flags) {
        list.add((ITextComponent)new TranslationTextComponent(ItemAIOTBase.getModeString(stack)));
    }

    public boolean func_150897_b(BlockState block) {
        return block.getHarvestLevel() <= this.mat.func_200925_d();
    }
}

