/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.peripherals.owner;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.lib.LibConfig;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralCheck;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralFunction;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralPlugin;
import de.srendi.advancedperipherals.lib.peripherals.owner.FuelAbility;
import de.srendi.advancedperipherals.lib.peripherals.owner.IOwnerAbility;
import de.srendi.advancedperipherals.lib.peripherals.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.PeripheralOwnerAbility;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OperationAbility
implements IOwnerAbility,
IPeripheralPlugin {
    private static final String COOLDOWNS_TAG = "cooldowns";
    private final Map<String, IPeripheralOperation<?>> allowedOperations = new HashMap();
    private final IPeripheralOwner owner;

    public OperationAbility(IPeripheralOwner owner) {
        this.owner = owner;
    }

    protected void setCooldown(@NotNull IPeripheralOperation<?> operation, int cooldown) {
        if (cooldown > 0) {
            CompoundNBT dataStorage = this.owner.getDataStorage();
            if (!dataStorage.func_74764_b(COOLDOWNS_TAG)) {
                dataStorage.func_218657_a(COOLDOWNS_TAG, (INBT)new CompoundNBT());
            }
            dataStorage.func_74775_l(COOLDOWNS_TAG).func_74772_a(operation.settingsName(), Timestamp.valueOf(LocalDateTime.now().plus(cooldown, ChronoUnit.MILLIS)).getTime());
        }
    }

    protected int getCooldown(@NotNull IPeripheralOperation<?> operation) {
        String operationName;
        CompoundNBT dataStorage = this.owner.getDataStorage();
        if (!dataStorage.func_74764_b(COOLDOWNS_TAG)) {
            return 0;
        }
        CompoundNBT cooldowns = dataStorage.func_74775_l(COOLDOWNS_TAG);
        if (!cooldowns.func_74764_b(operationName = operation.settingsName())) {
            return 0;
        }
        long currentTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        return (int)Math.max(0L, cooldowns.func_74763_f(operationName) - currentTime);
    }

    public void registerOperation(@NotNull IPeripheralOperation<?> operation) {
        int initialCooldown;
        this.allowedOperations.put(operation.settingsName(), operation);
        if (LibConfig.isInitialCooldownEnabled && (initialCooldown = operation.getInitialCooldown()) >= LibConfig.initialCooldownSensetiveLevel) {
            this.setCooldown(operation, initialCooldown);
        }
    }

    @NotNull
    public <T> MethodResult performOperation(IPeripheralOperation<T> operation, T context, @Nullable IPeripheralCheck<T> check, IPeripheralFunction<T, MethodResult> method, @Nullable Consumer<T> successCallback, @Nullable BiConsumer<MethodResult, FailReason> failCallback) throws LuaException {
        MethodResult checkResult;
        if (this.isOnCooldown(operation)) {
            MethodResult result = MethodResult.of((Object[])new Object[]{null, String.format("%s is on cooldown", operation.settingsName())});
            if (failCallback != null) {
                failCallback.accept(result, FailReason.COOLDOWN);
            }
            return result;
        }
        if (check != null && (checkResult = check.check(context)) != null) {
            if (failCallback != null) {
                failCallback.accept(checkResult, FailReason.CHECK_FAILED);
            }
            return checkResult;
        }
        int cost = operation.getCost(context);
        int cooldown = operation.getCooldown(context);
        if (cost != 0) {
            FuelAbility<?> fuelAbility = this.owner.getAbility(PeripheralOwnerAbility.FUEL);
            if (fuelAbility == null) {
                MethodResult result = MethodResult.of((Object[])new Object[]{null, "This peripheral has no fuel at all"});
                if (failCallback != null) {
                    failCallback.accept(result, FailReason.NOT_ENOUGH_FUEL);
                }
                return result;
            }
            if (!fuelAbility.consumeFuel(cost, false)) {
                MethodResult result = MethodResult.of((Object[])new Object[]{null, "Not enough fuel for operation"});
                if (failCallback != null) {
                    failCallback.accept(result, FailReason.NOT_ENOUGH_FUEL);
                }
                return result;
            }
            cooldown = fuelAbility.reduceCooldownAccordingToConsumptionRate(cooldown);
        }
        MethodResult result = method.apply(context);
        if (successCallback != null) {
            successCallback.accept(context);
        }
        this.setCooldown(operation, cooldown);
        return result;
    }

    public int getCurrentCooldown(IPeripheralOperation<?> operation) {
        return this.getCooldown(operation);
    }

    public boolean isOnCooldown(IPeripheralOperation<?> operation) {
        return this.getCurrentCooldown(operation) > 0;
    }

    @Override
    public void collectConfiguration(Map<String, Object> dict) {
        for (IPeripheralOperation<?> operation : this.allowedOperations.values()) {
            dict.put(operation.settingsName(), operation.computerDescription());
        }
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getOperationCooldown(String name) {
        IPeripheralOperation<?> op = this.allowedOperations.get(name);
        if (op == null) {
            return MethodResult.of((Object[])new Object[]{null, "Cannot find this operation"});
        }
        return MethodResult.of((Object)this.getCurrentCooldown(op));
    }

    public static enum FailReason {
        COOLDOWN,
        NOT_ENOUGH_FUEL,
        CHECK_FAILED;

    }
}

