/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.NotNull;

public class LuaConverter {
    public static Map<String, Object> entityToLua(Entity entity) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", entity.func_145782_y());
        data.put("uuid", entity.func_189512_bd());
        data.put("name", entity.func_200200_C_().getString());
        data.put("tags", entity.func_184216_O());
        return data;
    }

    public static Map<String, Object> animalToLua(AnimalEntity animal, ItemStack itemInHand) {
        Map<String, Object> data = LuaConverter.entityToLua((Entity)animal);
        data.put("baby", animal.func_70631_g_());
        data.put("inLove", animal.func_70880_s());
        data.put("aggressive", animal.func_213398_dR());
        if (animal instanceof IForgeShearable && !itemInHand.func_190926_b()) {
            IForgeShearable shareable = (IForgeShearable)animal;
            data.put("shareable", shareable.isShearable(itemInHand, animal.field_70170_p, animal.func_233580_cy_()));
        }
        return data;
    }

    public static Map<String, Object> completeEntityToLua(Entity entity, ItemStack itemInHand) {
        if (entity instanceof AnimalEntity) {
            return LuaConverter.animalToLua((AnimalEntity)entity, itemInHand);
        }
        return LuaConverter.entityToLua(entity);
    }

    public static Map<String, Object> completeEntityWithPositionToLua(Entity entity, ItemStack itemInHand, BlockPos pos) {
        Map<String, Object> data = LuaConverter.completeEntityToLua(entity, itemInHand);
        data.put("x", entity.func_226277_ct_() - (double)pos.func_177958_n());
        data.put("y", entity.func_226278_cu_() - (double)pos.func_177956_o());
        data.put("z", entity.func_226281_cx_() - (double)pos.func_177952_p());
        return data;
    }

    public static Object posToObject(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("x", pos.func_177958_n());
        map.put("y", pos.func_177956_o());
        map.put("z", pos.func_177952_p());
        return map;
    }

    public static Map<String, Object> stackToObject(@NotNull ItemStack stack) {
        if (stack.func_190926_b()) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> map = LuaConverter.itemToObject(stack.func_77973_b());
        CompoundNBT nbt = stack.func_77978_p();
        map.put("count", stack.func_190916_E());
        map.put("displayName", stack.func_151000_E().getString());
        map.put("maxStackSize", stack.func_77976_d());
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        map.put("nbt", NBTUtil.toLua((INBT)nbt));
        return map;
    }

    public static Map<String, Object> itemToObject(@NotNull Item item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tags", LuaConverter.tagsToList(item.getTags()));
        map.put("name", item.getRegistryName().toString());
        return map;
    }

    public static List<String> tagsToList(@NotNull Set<ResourceLocation> tags) {
        if (tags.isEmpty()) {
            return null;
        }
        return tags.stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public static Direction getDirection(Direction facing, String computerSide) throws LuaException {
        if (Direction.func_176739_a((String)computerSide) != null) {
            return Direction.func_176739_a((String)computerSide);
        }
        if (Objects.equals(computerSide, ComputerSide.FRONT.toString())) {
            return facing;
        }
        if (Objects.equals(computerSide, ComputerSide.BACK.toString())) {
            return facing.func_176734_d();
        }
        if (Objects.equals(computerSide, ComputerSide.TOP.toString())) {
            return Direction.UP;
        }
        if (Objects.equals(computerSide, ComputerSide.BOTTOM.toString())) {
            return Direction.DOWN;
        }
        if (Objects.equals(computerSide, ComputerSide.RIGHT.toString())) {
            return facing.func_176735_f();
        }
        if (Objects.equals(computerSide, ComputerSide.LEFT.toString())) {
            return facing.func_176746_e();
        }
        throw new LuaException(computerSide + " is not a valid side");
    }

    public static BlockPos convertToBlockPos(Map<?, ?> table) throws LuaException {
        if (!(table.containsKey("x") && table.containsKey("y") && table.containsKey("z"))) {
            throw new LuaException("Table should be block position table");
        }
        Object x = table.get("x");
        Object y = table.get("y");
        Object z = table.get("z");
        if (!(x instanceof Number && y instanceof Number && z instanceof Number)) {
            throw new LuaException("Table should be block position table");
        }
        return new BlockPos(((Number)x).intValue(), ((Number)y).intValue(), ((Number)z).intValue());
    }

    public static BlockPos convertToBlockPos(BlockPos center, Map<?, ?> table) throws LuaException {
        BlockPos relative = LuaConverter.convertToBlockPos(table);
        return new BlockPos(center.func_177958_n() + relative.func_177958_n(), center.func_177956_o() + relative.func_177956_o(), center.func_177952_p() + relative.func_177952_p());
    }
}

