/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.configuration;

import de.srendi.advancedperipherals.common.configuration.IAPConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class WorldConfig
implements IAPConfig {
    public final ForgeConfigSpec.BooleanValue ENABLE_VILLAGER_STRUCTURES;
    public final ForgeConfigSpec.BooleanValue GIVE_PLAYER_BOOK_ON_JOIN;
    public final ForgeConfigSpec.IntValue VILLAGER_STRUCTURE_WEIGHT;
    private final ForgeConfigSpec configSpec;

    public WorldConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Config to adjust world settings").push("World");
        this.ENABLE_VILLAGER_STRUCTURES = builder.comment("Enable the villager structures for the computer scientist.").define("enableVillagerStructures", true);
        this.GIVE_PLAYER_BOOK_ON_JOIN = builder.comment("Gives the ap documentation to new players on a world.").define("givePlayerBookOnJoin", true);
        this.VILLAGER_STRUCTURE_WEIGHT = builder.comment("The weight of the villager structures").defineInRange("villagerStructureWeight", 10, 0, 16000);
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public String getFileName() {
        return "world";
    }

    @Override
    public ModConfig.Type getType() {
        return ModConfig.Type.COMMON;
    }
}

