/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class DrawerItemHandler
implements IItemHandler {
    private final IDrawerGroup group;

    public DrawerItemHandler(IDrawerGroup group) {
        this.group = group;
    }

    public int getSlots() {
        return this.group.getDrawerCount();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.group.getDrawer(slot).getStoredItemPrototype();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        IDrawer drawer = this.group.getDrawer(slot);
        int stackCount = stack.func_190916_E();
        if (!drawer.canItemBeStored(stack)) {
            return stack;
        }
        int currentCount = 0;
        if (!drawer.isEmpty()) {
            currentCount = drawer.getStoredItemCount();
        }
        int storedCount = Math.min(stackCount, drawer.getMaxCapacity(stack) - currentCount);
        if (!simulate) {
            if (drawer.isEmpty()) {
                drawer.setStoredItem(stack);
            }
            drawer.setStoredItemCount(storedCount + currentCount);
        }
        if (storedCount == stackCount) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackCopy = stack.func_77946_l();
        stackCopy.func_190920_e(stackCount - storedCount);
        return stackCopy;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IDrawer drawer = this.group.getDrawer(slot);
        if (drawer.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        int currentCount = drawer.getStoredItemCount();
        int extractedCount = Math.min(currentCount, amount);
        ItemStack extracted = drawer.getStoredItemPrototype().func_77946_l();
        extracted.func_190920_e(extractedCount);
        if (!simulate) {
            drawer.setStoredItemCount(currentCount - extractedCount);
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        IDrawer drawer = this.group.getDrawer(slot);
        if (drawer.isEmpty()) {
            return drawer.getMaxCapacity();
        }
        return drawer.getMaxCapacity(drawer.getStoredItemPrototype());
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        IDrawer drawer = this.group.getDrawer(slot);
        if (drawer.isEmpty()) {
            return true;
        }
        return stack.func_77973_b() == drawer.getStoredItemPrototype().func_77973_b();
    }
}

