/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.research.IGlobalResearchTree;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketAccess;
import de.srendi.advancedperipherals.common.addons.minecolonies.MineColonies;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.TileEntityPeripheralOwner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ModList;

public class ColonyPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String TYPE = "colonyIntegrator";
    protected boolean hasPermission = true;

    public ColonyPeripheral(PeripheralTileEntity<?> tileEntity) {
        super(TYPE, new TileEntityPeripheralOwner(tileEntity));
    }

    public ColonyPeripheral(IPocketAccess access) {
        super(TYPE, new PocketPeripheralOwner(access));
    }

    @Override
    public boolean isEnabled() {
        return ModList.get().isLoaded("minecolonies") && (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_COLONY_INTEGRATOR.get() != false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isInColony() {
        return this.getColonyWithoutPermission() != null;
    }

    @LuaFunction(mainThread=true)
    public final boolean isWithin(Map<?, ?> pos) throws LuaException {
        IColony colony = this.getColonyWithoutPermission();
        if (!(pos.containsKey("x") && pos.containsKey("y") && pos.containsKey("z"))) {
            throw new LuaException("Coordinates expected");
        }
        BlockPos p = new BlockPos(((Number)pos.get("x")).intValue(), ((Number)pos.get("y")).intValue(), ((Number)pos.get("z")).intValue());
        return colony.isCoordInColony(this.getWorld(), p);
    }

    @LuaFunction(mainThread=true)
    public final Object getCitizens() throws LuaException {
        IColony colony = this.getColony();
        ArrayList list = new ArrayList();
        colony.getCitizenManager().getCitizens().forEach(citizen -> list.add(MineColonies.citizenToObject(citizen)));
        return list;
    }

    @LuaFunction(mainThread=true)
    public final int amountOfConstructionSites() throws LuaException {
        return MineColonies.getAmountOfConstructionSites(this.getColony());
    }

    @LuaFunction(mainThread=true)
    public final int getColonyID() throws LuaException {
        IColony colony = this.getColony();
        return colony.getID();
    }

    @LuaFunction(mainThread=true)
    public final String getColonyName() throws LuaException {
        IColony colony = this.getColony();
        return colony.getName();
    }

    @LuaFunction(mainThread=true)
    public final String getColonyStyle() throws LuaException {
        IColony colony = this.getColony();
        return colony.getStyle();
    }

    @LuaFunction(mainThread=true)
    public final boolean isActive() throws LuaException {
        IColony colony = this.getColony();
        return colony.isActive();
    }

    @LuaFunction(mainThread=true)
    public final double getHappiness() throws LuaException {
        IColony colony = this.getColony();
        return colony.getOverallHappiness();
    }

    @LuaFunction(mainThread=true)
    public final Object getLocation() throws LuaException {
        IColony colony = this.getColony();
        return LuaConverter.posToObject(colony.getCenter());
    }

    @LuaFunction(mainThread=true)
    public final boolean isUnderAttack() throws LuaException {
        IColony colony = this.getColony();
        return colony.isColonyUnderAttack();
    }

    @LuaFunction(mainThread=true)
    public final int amountOfCitizens() throws LuaException {
        IColony colony = this.getColony();
        return colony.getCitizenManager().getCurrentCitizenCount();
    }

    @LuaFunction(mainThread=true)
    public final int maxOfCitizens() throws LuaException {
        IColony colony = this.getColony();
        return colony.getCitizenManager().getMaxCitizens();
    }

    @LuaFunction(mainThread=true)
    public final int amountOfGraves() throws LuaException {
        IColony colony = this.getColony();
        return colony.getGraveManager().getGraves().size();
    }

    @LuaFunction(mainThread=true)
    public final Object getVisitors() throws LuaException {
        IColony colony = this.getColony();
        ArrayList<Object> list = new ArrayList<Object>();
        for (ICivilianData civilian : colony.getVisitorManager().getCivilianDataMap().values()) {
            if (!(civilian instanceof IVisitorData)) continue;
            list.add(MineColonies.visitorToObject((IVisitorData)civilian));
        }
        return list;
    }

    @LuaFunction(mainThread=true)
    public final Object getBuildings() throws LuaException {
        IColony colony = this.getColony();
        IRegisteredStructureManager manager = colony.getBuildingManager();
        ArrayList<Object> buildingData = new ArrayList<Object>();
        for (Map.Entry building : manager.getBuildings().entrySet()) {
            buildingData.add(MineColonies.buildingToObject(manager, (IBuilding)building.getValue(), (BlockPos)building.getKey()));
        }
        return buildingData;
    }

    @LuaFunction(mainThread=true)
    public final Object getWorkOrders() throws LuaException {
        IColony colony = this.getColony();
        ArrayList<Object> worksData = new ArrayList<Object>();
        for (IWorkOrder workOrder : colony.getWorkManager().getWorkOrders().values()) {
            worksData.add(MineColonies.workOrderToObject(workOrder));
        }
        return worksData;
    }

    @LuaFunction(mainThread=true)
    public final Object getResearch() throws LuaException {
        IColony colony = this.getColony();
        IGlobalResearchTree globalTree = IGlobalResearchTree.getInstance();
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        for (ResourceLocation branch : globalTree.getBranches()) {
            result.put(branch.toString(), MineColonies.getResearch(branch, globalTree.getPrimaryResearch(branch), colony));
        }
        return result;
    }

    @LuaFunction(mainThread=true)
    public final Object getWorkOrderResources(int id) throws LuaException {
        IColony colony = this.getColony();
        IWorkOrder workOrder = colony.getWorkManager().getWorkOrder(id);
        if (workOrder == null) {
            return null;
        }
        return MineColonies.builderResourcesToObject(colony, workOrder.getClaimedBy());
    }

    @LuaFunction(mainThread=true)
    public final Object getBuilderResources(Map<?, ?> pos) throws LuaException {
        IColony colony = this.getColony();
        if (!(pos.containsKey("x") && pos.containsKey("y") && pos.containsKey("z"))) {
            throw new LuaException("Coordinates expected");
        }
        BlockPos blockPos = new BlockPos(((Number)pos.get("x")).intValue(), ((Number)pos.get("y")).intValue(), ((Number)pos.get("z")).intValue());
        return MineColonies.builderResourcesToObject(colony, blockPos);
    }

    @LuaFunction(mainThread=true)
    public final Object getRequests() throws LuaException {
        IColony colony = this.getColony();
        IRequestManager requestManager = colony.getRequestManager();
        IPlayerRequestResolver playerResolver = requestManager.getPlayerResolver();
        IRetryingRequestResolver requestResolver = requestManager.getRetryingRequestResolver();
        HashSet tokens = new HashSet();
        tokens.addAll(playerResolver.getAllAssignedRequests());
        tokens.addAll(requestResolver.getAllAssignedRequests());
        ArrayList<IRequest> requests = new ArrayList<IRequest>();
        for (IToken token : tokens) {
            IRequest request2 = requestManager.getRequestForToken(token);
            if (!(request2.getRequest() instanceof IDeliverable)) continue;
            requests.add(request2);
        }
        ArrayList result = new ArrayList();
        requests.forEach(request -> {
            IDeliverable deliverableRequest = (IDeliverable)request.getRequest();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", request.getId().getIdentifier().toString());
            map.put("name", TextFormatting.func_110646_a((String)request.getShortDisplayString().getString()));
            map.put("desc", TextFormatting.func_110646_a((String)request.getLongDisplayString().getString()));
            map.put("state", request.getState().toString());
            map.put("count", deliverableRequest.getCount());
            map.put("minCount", deliverableRequest.getMinimumCount());
            map.put("items", request.getDisplayStacks().stream().map(LuaConverter::stackToObject).collect(Collectors.toList()));
            map.put("target", request.getRequester().getRequesterDisplayName(requestManager, request).getString());
            result.add(map);
        });
        return result;
    }

    private IColony getColony() throws LuaException {
        IMinecoloniesAPI api = IMinecoloniesAPI.getInstance();
        IColony colony = api.getColonyManager().getColonyByPosFromWorld(this.getWorld(), this.getPos());
        boolean bl = this.hasPermission = !(this.owner instanceof PocketPeripheralOwner) || MineColonies.hasAccess((Entity)this.owner.getOwner(), colony);
        if (colony == null || !this.hasPermission) {
            throw new LuaException("Here is no colony or you don't have the right permissions");
        }
        return colony;
    }

    private IColony getColonyWithoutPermission() {
        IMinecoloniesAPI api = IMinecoloniesAPI.getInstance();
        return api.getColonyManager().getColonyByPosFromWorld(this.getWorld(), this.getPos());
    }
}

