/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import com.google.gson.JsonSyntaxException;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SimpleFreeOperation;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralFunction;
import de.srendi.advancedperipherals.lib.peripherals.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.TileEntityPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.TurtlePeripheralOwner;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ChatBoxPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String TYPE = "chatBox";

    protected ChatBoxPeripheral(IPeripheralOwner owner) {
        super(TYPE, owner);
        owner.attachOperation(SimpleFreeOperation.CHAT_MESSAGE);
    }

    public ChatBoxPeripheral(PeripheralTileEntity<?> tileEntity) {
        this(new TileEntityPeripheralOwner(tileEntity));
    }

    public ChatBoxPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this(new TurtlePeripheralOwner(turtle, side));
    }

    public ChatBoxPeripheral(IPocketAccess pocket) {
        this(new PocketPeripheralOwner(pocket));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_CHAT_BOX.get();
    }

    protected MethodResult withChatOperation(IPeripheralFunction<Object, MethodResult> function) throws LuaException {
        return this.withOperation(SimpleFreeOperation.CHAT_MESSAGE, null, null, function, null);
    }

    private IFormattableTextComponent appendPrefix(String prefix, String brackets, String color) {
        StringTextComponent prefixComponent = new StringTextComponent((String)APConfig.PERIPHERALS_CONFIG.DEFAULT_CHAT_BOX_PREFIX.get());
        if (!prefix.isEmpty()) {
            try {
                IFormattableTextComponent formattablePrefix = ITextComponent.Serializer.func_240643_a_((String)prefix);
                prefixComponent = (TextComponent)formattablePrefix;
            }
            catch (JsonSyntaxException exception) {
                AdvancedPeripherals.debug("Non json prefix, using plain text instead.");
                prefixComponent = new StringTextComponent(prefix);
            }
        }
        if (brackets.isEmpty()) {
            brackets = "[]";
        }
        return new StringTextComponent(color + brackets.charAt(0) + "\u00a7r").func_230529_a_((ITextComponent)prefixComponent).func_240702_b_(color + brackets.charAt(1) + "\u00a7r ");
    }

    private ServerPlayerEntity getPlayer(String argument) {
        if (argument.matches("\\b[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\\b")) {
            return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(UUID.fromString(argument));
        }
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(argument);
    }

    private boolean checkBrackets(Optional<String> brackets) {
        return brackets.isPresent() && brackets.get().length() != 2;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendFormattedMessage(@Nonnull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            int range = arguments.optInt(4, -1);
            IFormattableTextComponent component = ITextComponent.Serializer.func_240643_a_((String)message);
            if (component == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json"});
            }
            if (this.checkBrackets(arguments.optString(2))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            IFormattableTextComponent preparedMessage = this.appendPrefix(arguments.optString(1, (String)APConfig.PERIPHERALS_CONFIG.DEFAULT_CHAT_BOX_PREFIX.get()), arguments.optString(2, "[]"), arguments.optString(3, "")).func_230529_a_((ITextComponent)component);
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                if (range != -1) {
                    if (!CoordUtil.isInRange(this.getPos(), this.getWorld(), (PlayerEntity)player, range)) continue;
                    player.func_145747_a((ITextComponent)preparedMessage, Util.field_240973_b_);
                    continue;
                }
                player.func_145747_a((ITextComponent)preparedMessage, Util.field_240973_b_);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendMessage(@Nonnull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            int range = arguments.optInt(4, -1);
            if (this.checkBrackets(arguments.optString(2))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            IFormattableTextComponent preparedMessage = this.appendPrefix(arguments.optString(1, (String)APConfig.PERIPHERALS_CONFIG.DEFAULT_CHAT_BOX_PREFIX.get()), arguments.optString(2, "[]"), arguments.optString(3, "")).func_240702_b_(message);
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                if (range != -1) {
                    if (!CoordUtil.isInRange(this.getPos(), this.getWorld(), (PlayerEntity)player, range)) continue;
                    player.func_145747_a((ITextComponent)preparedMessage, Util.field_240973_b_);
                    continue;
                }
                player.func_145747_a((ITextComponent)preparedMessage, Util.field_240973_b_);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendFormattedMessageToPlayer(@Nonnull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            String playerName = arguments.getString(1);
            ServerPlayerEntity player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            IFormattableTextComponent component = ITextComponent.Serializer.func_240643_a_((String)message);
            if (component == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json"});
            }
            if (this.checkBrackets(arguments.optString(3))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            IFormattableTextComponent preparedMessage = this.appendPrefix(arguments.optString(2, (String)APConfig.PERIPHERALS_CONFIG.DEFAULT_CHAT_BOX_PREFIX.get()), arguments.optString(3, "[]"), arguments.optString(4, "")).func_230529_a_((ITextComponent)component);
            player.func_145747_a((ITextComponent)preparedMessage, Util.field_240973_b_);
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendMessageToPlayer(@Nonnull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            String playerName = arguments.getString(1);
            ServerPlayerEntity player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            if (this.checkBrackets(arguments.optString(3))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            IFormattableTextComponent preparedMessage = this.appendPrefix(arguments.optString(2, (String)APConfig.PERIPHERALS_CONFIG.DEFAULT_CHAT_BOX_PREFIX.get()), arguments.optString(3, "[]"), arguments.optString(4, "")).func_240702_b_(message);
            player.func_145747_a((ITextComponent)preparedMessage, Util.field_240973_b_);
            return MethodResult.of((Object)true);
        });
    }
}

