/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.yogpc.qp.utils.ProxyClient;
import com.yogpc.qp.utils.ProxyCommon;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkEvent;

public class ProxyProvider {
    public static AbstractProxy getInstance() {
        switch (FMLEnvironment.dist) {
            case CLIENT: {
                return new ClientSupplier().get();
            }
            case DEDICATED_SERVER: {
                return new ServerSupplier().get();
            }
        }
        throw new IllegalArgumentException("UN SIDED?");
    }

    private static class ServerSupplier
    implements Supplier<AbstractProxy> {
        private ServerSupplier() {
        }

        @Override
        public AbstractProxy get() {
            return new ProxyCommon();
        }
    }

    private static class ClientSupplier
    implements Supplier<AbstractProxy> {
        private ClientSupplier() {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public AbstractProxy get() {
            return new ProxyClient();
        }
    }

    public static abstract class AbstractProxy {
        public abstract Optional<PlayerEntity> getPacketPlayer(NetworkEvent.Context var1);

        public abstract Optional<World> getPacketWorld(NetworkEvent.Context var1);

        public abstract void removeEntity(Entity var1);

        @Nullable
        public abstract World getClientWorld();

        public abstract void setDummyTexture(String var1);

        public static int toInt(long l) {
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (l < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)l;
        }
    }
}

