/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentIngredient
extends Ingredient {
    private final ItemStack stack;
    private final List<EnchantmentData> enchantments;
    private final CompoundNBT withoutEnchantment;

    public EnchantmentIngredient(ItemStack stack, List<EnchantmentData> enchantments) {
        super(Stream.of(new Ingredient.SingleItemList(EnchantmentIngredient.addEnchantments(stack, enchantments))));
        this.stack = stack;
        this.enchantments = enchantments;
        this.withoutEnchantment = Optional.ofNullable(stack.getShareTag()).map(CompoundNBT::func_74737_b).map(c -> {
            c.func_82580_o("Enchantments");
            return c;
        }).filter(c -> !c.isEmpty()).orElse(null);
    }

    public boolean isSimple() {
        return false;
    }

    public JsonElement func_200304_c() {
        JsonObject object = new JsonObject();
        Serializer.INSTANCE.write(object, this);
        return object;
    }

    public boolean test(@Nullable ItemStack p_test_1_) {
        if (p_test_1_ == null) {
            return false;
        }
        if (this.stack.func_77973_b() != p_test_1_.func_77973_b() || this.stack.func_190916_E() != p_test_1_.func_190916_E()) {
            return false;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)p_test_1_);
        if (!this.enchantments.stream().allMatch(d -> enchantments.getOrDefault(d.field_76302_b, 0) >= d.field_76303_c)) {
            return false;
        }
        CompoundNBT nbt = Optional.ofNullable(p_test_1_.getShareTag()).map(CompoundNBT::func_74737_b).map(c -> {
            c.func_82580_o("Enchantments");
            return c;
        }).filter(c -> !c.isEmpty()).orElse(null);
        return Objects.equals(this.withoutEnchantment, nbt);
    }

    private static ItemStack addEnchantments(ItemStack stack, List<EnchantmentData> enchantments) {
        ItemStack toEnchantment = stack.func_77946_l();
        enchantments.forEach(d -> toEnchantment.func_77966_a(d.field_76302_b, d.field_76303_c));
        return toEnchantment;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<EnchantmentIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public EnchantmentIngredient parse(PacketBuffer buffer) {
            ItemStack stack = buffer.func_150791_c();
            int size = buffer.func_150792_a();
            List<EnchantmentData> data = IntStream.range(0, size).mapToObj(operand -> {
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.func_192575_l());
                int level = buffer.readInt();
                return new EnchantmentData(Objects.requireNonNull(enchantment), level);
            }).collect(Collectors.toList());
            return new EnchantmentIngredient(stack, data);
        }

        public EnchantmentIngredient parse(JsonObject json) {
            List<Object> data;
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
            if (json.has("enchantments")) {
                JsonArray enchantmentArray = json.getAsJsonArray("enchantments");
                data = StreamSupport.stream(enchantmentArray.spliterator(), false).map(JsonElement::getAsJsonObject).map(o -> {
                    Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)o, (String)"id")));
                    int level = JSONUtils.func_151208_a((JsonObject)o, (String)"level", (int)1);
                    return new EnchantmentData(Objects.requireNonNull(enchantment), level);
                }).collect(Collectors.toList());
            } else {
                data = Collections.emptyList();
            }
            return new EnchantmentIngredient(stack, data);
        }

        public void write(PacketBuffer buffer, EnchantmentIngredient ingredient) {
            buffer.func_150788_a(ingredient.stack);
            buffer.func_150787_b(ingredient.enchantments.size());
            for (EnchantmentData data : ingredient.enchantments) {
                buffer.func_192572_a(Objects.requireNonNull(data.field_76302_b.getRegistryName()));
                buffer.writeInt(data.field_76303_c);
            }
        }

        public void write(JsonObject json, EnchantmentIngredient ingredient) {
            JsonArray enchantmentArray;
            json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)INSTANCE).toString());
            json.addProperty("item", ingredient.stack.func_77973_b().getRegistryName().toString());
            json.addProperty("count", (Number)ingredient.stack.func_190916_E());
            if (ingredient.stack.func_77942_o()) {
                JsonElement element = (JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)ingredient.stack.func_77978_p());
                json.add("nbt", element);
            }
            if ((enchantmentArray = ingredient.enchantments.stream().reduce(new JsonArray(), (jsonElements, enchantmentData) -> {
                JsonObject object = new JsonObject();
                object.addProperty("id", enchantmentData.field_76302_b.getRegistryName().toString());
                object.addProperty("level", (Number)enchantmentData.field_76303_c);
                jsonElements.add((JsonElement)object);
                return jsonElements;
            }, (jsonElements, jsonElements2) -> {
                jsonElements.addAll(jsonElements2);
                return jsonElements;
            })).size() != 0) {
                json.add("enchantments", (JsonElement)enchantmentArray);
            }
        }
    }
}

