/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.test;

import com.yogpc.qp.machines.workbench.WorkbenchRecipes;
import com.yogpc.qp.utils.Holder;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.jdk.javaapi.CollectionConverters;

final class ItemAccessTest {
    ItemAccessTest() {
    }

    @Test
    void exist() {
        Item item = Holder.itemStatusChecker();
        Assertions.assertEquals((Object)new ResourceLocation("quarryplus", "statuschecker"), (Object)item.getRegistryName());
    }

    public static Stream<Block> myBlocksInForgeRegistry() {
        return CollectionConverters.asJava(Holder.blocks()).stream();
    }

    @ParameterizedTest
    @MethodSource
    void myBlocksInForgeRegistry(Block block) {
        IForgeRegistry blocks = ForgeRegistries.BLOCKS;
        Assertions.assertTrue((boolean)blocks.containsValue((IForgeRegistryEntry)block), (String)"Block is in forge registry.");
    }

    public static Stream<Item> myItemsInForgeRegistry() {
        return CollectionConverters.asJava(Holder.items()).stream();
    }

    @ParameterizedTest
    @MethodSource
    void myItemsInForgeRegistry(Item item) {
        IForgeRegistry items = ForgeRegistries.ITEMS;
        Assertions.assertTrue((boolean)items.containsValue((IForgeRegistryEntry)item), (String)"Item is in registry.");
    }

    @Test
    void accessToClass() {
        Assertions.assertDoesNotThrow(() -> new ItemStack((IItemProvider)Items.field_205158_fa));
        WorkbenchRecipes recipes2 = WorkbenchRecipes.dummyRecipe();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)recipes2.func_77571_b().func_190926_b()), () -> Assertions.assertFalse((boolean)recipes2.hasContent())});
    }

    public static Stream<Enchantment> accessToEnchantment() {
        return Stream.of(Enchantments.field_185306_r, Enchantments.field_185302_k, Enchantments.field_185308_t, Enchantments.field_185305_q);
    }

    @ParameterizedTest
    @MethodSource
    void accessToEnchantment(Enchantment enchantment) {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)enchantment), () -> Assertions.assertNotNull((Object)enchantment.getRegistryName()), () -> Assertions.assertTrue((boolean)ForgeRegistries.ENCHANTMENTS.containsValue((IForgeRegistryEntry)enchantment))});
    }

    @Test
    void CANT_AccessToCapability() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNull((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY), () -> Assertions.assertNull((Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY), () -> Assertions.assertNull((Object)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY), () -> Assertions.assertNull((Object)CapabilityEnergy.ENERGY)});
    }

    @Test
    void dummy() {
        Assertions.assertTrue((ItemAccessTest.accessToEnchantment().count() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((ItemAccessTest.myBlocksInForgeRegistry().count() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((ItemAccessTest.myItemsInForgeRegistry().count() > 0L ? 1 : 0) != 0);
    }
}

