/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.pump;

import com.yogpc.qp.machines.pump.TilePump;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.utils.FluidElement;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class Mappings {

    public static enum Type {
        None(0),
        Remove(1),
        Add(2),
        Up(3),
        Top(4),
        Down(5),
        Bottom(6);

        public final int id;

        private Type(int i) {
            this.id = i;
        }

        public int getId() {
            return this.id;
        }

        public static Type fromID(int id) {
            switch (id) {
                case 1: {
                    return Remove;
                }
                case 2: {
                    return Add;
                }
                case 3: {
                    return Up;
                }
                case 4: {
                    return Top;
                }
                case 5: {
                    return Down;
                }
                case 6: {
                    return Bottom;
                }
            }
            return None;
        }
    }

    public static class Copy
    implements IMessage<Copy> {
        BlockPos pos;
        ResourceLocation dim;
        Direction dest;
        List<FluidElement> list;

        public static Copy create(TilePump pump, Direction dest, List<FluidElement> list) {
            Copy copy = new Copy();
            copy.dest = dest;
            copy.pos = pump.func_174877_v();
            copy.list = list;
            copy.dim = IMessage.getDimId(pump.func_145831_w());
            return copy;
        }

        @Override
        public Copy readFromBuffer(PacketBuffer buffer) {
            this.pos = buffer.func_179259_c();
            this.dest = (Direction)buffer.func_179257_a(Direction.class);
            this.dim = buffer.func_192575_l();
            int length = buffer.readInt();
            this.list = new LinkedList<FluidElement>();
            for (int i = 0; i < length; ++i) {
                this.list.add(FluidElement.fromNBT(buffer.func_150793_b()));
            }
            return this;
        }

        @Override
        public void writeToBuffer(PacketBuffer buffer) {
            buffer.func_179255_a(this.pos).func_179249_a((Enum)this.dest).func_192572_a(this.dim).writeInt(this.list.size());
            this.list.stream().map(FluidElement::toCompoundTag).forEach(arg_0 -> ((PacketBuffer)buffer).func_150786_a(arg_0));
        }

        @Override
        public void onReceive(Supplier<NetworkEvent.Context> ctx) {
            IMessage.findTile(ctx, this.pos, this.dim, TilePump.class).ifPresent(pump -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> pump.getStorage().mapping.put(this.dest, this.list)));
        }
    }

    public static class Update
    implements IMessage<Update> {
        Type type;
        Direction facing;
        BlockPos pos;
        ResourceLocation dim;
        ResourceLocation fluidName;

        public static Update create(TilePump pump, Direction facing, Type type, ResourceLocation fluidName) {
            Update update = new Update();
            update.facing = facing;
            update.pos = pump.func_174877_v();
            update.type = type;
            update.fluidName = fluidName;
            update.dim = IMessage.getDimId(pump.func_145831_w());
            return update;
        }

        @Override
        public Update readFromBuffer(PacketBuffer buffer) {
            this.pos = buffer.func_179259_c();
            this.facing = (Direction)buffer.func_179257_a(Direction.class);
            this.type = (Type)buffer.func_179257_a(Type.class);
            this.fluidName = buffer.func_192575_l();
            this.dim = buffer.func_192575_l();
            return this;
        }

        @Override
        public void writeToBuffer(PacketBuffer buffer) {
            buffer.func_179255_a(this.pos).func_179249_a((Enum)this.facing).func_179249_a((Enum)this.type).func_192572_a(this.fluidName).func_192572_a(this.dim);
        }

        @Override
        public void onReceive(Supplier<NetworkEvent.Context> ctx) {
            IMessage.findTile(ctx, this.pos, this.dim, TilePump.class).ifPresent(pump -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
                List<FluidElement> list = pump.getStorage().mapping.get(this.facing);
                Update.typeAction(list, this.fluidName, this.type);
            }));
        }

        public static void typeAction(List<FluidElement> list, ResourceLocation fluidName, Type type) {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
            if (fluid != null) {
                FluidElement e = FluidElement.apply(fluid);
                int i = list.indexOf(e);
                switch (type) {
                    case Add: {
                        list.add(e);
                        break;
                    }
                    case Remove: {
                        list.remove(e);
                        break;
                    }
                    case Up: {
                        if (i <= 0) break;
                        list.remove(i);
                        list.add(i - 1, e);
                        break;
                    }
                    case Top: {
                        if (i <= 0) break;
                        list.remove(i);
                        list.add(0, e);
                        break;
                    }
                    case Down: {
                        if (i < 0 || i == list.size() - 1) break;
                        list.remove(i);
                        list.add(i + 1, e);
                        break;
                    }
                    case Bottom: {
                        if (i < 0 || i == list.size() - 1) break;
                        list.remove(i);
                        list.add(e);
                        break;
                    }
                }
            }
        }
    }

    public static class All
    implements IMessage<All> {
        BlockPos pos;
        ResourceLocation dim;
        Direction facing;
        EnumMap<Direction, List<FluidElement>> map = new EnumMap(Direction.class);

        public static All create(TilePump pump, Direction facing) {
            All message = new All();
            message.pos = pump.func_174877_v();
            message.dim = IMessage.getDimId(pump.func_145831_w());
            message.facing = facing;
            message.map = new EnumMap<Direction, List<FluidElement>>(pump.getStorage().mapping);
            return message;
        }

        @Override
        public All readFromBuffer(PacketBuffer buffer) {
            this.pos = buffer.func_179259_c();
            this.dim = buffer.func_192575_l();
            this.facing = (Direction)buffer.func_179257_a(Direction.class);
            for (Direction direction : Direction.values()) {
                int l = buffer.readInt();
                ArrayList<FluidElement> stacks = new ArrayList<FluidElement>(l);
                for (int j = 0; j < l; ++j) {
                    stacks.add(FluidElement.fromNBT(buffer.func_150793_b()));
                }
                this.map.put(direction, stacks);
            }
            return this;
        }

        @Override
        public void writeToBuffer(PacketBuffer buffer) {
            buffer.func_179255_a(this.pos).func_192572_a(this.dim);
            buffer.func_179249_a((Enum)this.facing);
            for (List<FluidElement> stacks : this.map.values()) {
                buffer.writeInt(stacks.size());
                stacks.forEach(s -> buffer.func_150786_a(s.toCompoundTag()));
            }
        }

        @Override
        public void onReceive(Supplier<NetworkEvent.Context> ctx) {
            IMessage.findTile(ctx, this.pos, this.dim, TilePump.class).ifPresent(pump -> {
                pump.getStorage().mapping.clear();
                pump.getStorage().mapping.putAll(this.map);
            });
        }
    }
}

