/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.mini_quarry;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.yogpc.qp.machines.base.QuarryBlackList;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryListGui;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryTile;
import com.yogpc.qp.packet.IMessage;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import scala.collection.immutable.Set;
import scala.jdk.javaapi.CollectionConverters;

public class MiniListSyncMessage
implements IMessage<MiniListSyncMessage> {
    BlockPos pos;
    ResourceLocation dim;
    CompoundNBT listTag;

    public static MiniListSyncMessage create(BlockPos blockPos, ResourceLocation dim, Set<QuarryBlackList.Entry> blackList, Set<QuarryBlackList.Entry> whiteList) {
        return MiniListSyncMessage.create(blockPos, dim, CollectionConverters.asJava(blackList), CollectionConverters.asJava(whiteList));
    }

    public static MiniListSyncMessage create(BlockPos blockPos, ResourceLocation dim, Collection<QuarryBlackList.Entry> blackList, Collection<QuarryBlackList.Entry> whiteList) {
        MiniListSyncMessage message = new MiniListSyncMessage();
        message.pos = blockPos;
        message.dim = dim;
        INBT listBlack = NBTDynamicOps.field_210820_a.createList(blackList.stream().map(e -> (INBT)QuarryBlackList.writeEntry(e, NBTDynamicOps.field_210820_a)));
        INBT listWhite = NBTDynamicOps.field_210820_a.createList(whiteList.stream().map(e -> (INBT)QuarryBlackList.writeEntry(e, NBTDynamicOps.field_210820_a)));
        message.listTag = new CompoundNBT();
        message.listTag.func_218657_a("black", listBlack);
        message.listTag.func_218657_a("white", listWhite);
        return message;
    }

    @Override
    public MiniListSyncMessage readFromBuffer(PacketBuffer buffer) {
        MiniListSyncMessage message = new MiniListSyncMessage();
        message.pos = buffer.func_179259_c();
        message.dim = buffer.func_192575_l();
        message.listTag = buffer.func_150793_b();
        return message;
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).func_192572_a(this.dim);
        buffer.func_150786_a(this.listTag);
    }

    @Override
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        Collection b = this.listTag.func_150295_c("black", 10).stream().map(n -> new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, n)).map(QuarryBlackList::readEntry).collect(Collectors.toList());
        Collection w = this.listTag.func_150295_c("white", 10).stream().map(n -> new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, n)).map(QuarryBlackList::readEntry).collect(Collectors.toList());
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            this.calledInClient(ctx, b, w);
        } else if (ctx.get().getDirection().getReceptionSide() == LogicalSide.SERVER) {
            this.calledInLogicalServer(ctx, b, w);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void calledInClient(Supplier<NetworkEvent.Context> ctx, Collection<QuarryBlackList.Entry> b, Collection<QuarryBlackList.Entry> w) {
        IMessage.findTile(ctx, this.pos, this.dim, MiniQuarryTile.class).ifPresent(t -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> Minecraft.func_71410_x().func_147108_a((Screen)new MiniQuarryListGui((MiniQuarryTile)t, w, b))));
    }

    private void calledInLogicalServer(Supplier<NetworkEvent.Context> ctx, Collection<QuarryBlackList.Entry> b, Collection<QuarryBlackList.Entry> w) {
        IMessage.findTile(ctx, this.pos, this.dim, MiniQuarryTile.class).ifPresent(t -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
            t.blackList_$eq((Set<QuarryBlackList.Entry>)CollectionConverters.asScala((Collection)b).toSet());
            t.whiteList_$eq((Set<QuarryBlackList.Entry>)CollectionConverters.asScala((Collection)w).toSet());
        }));
    }
}

