/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.SlotUnlimited;
import com.yogpc.qp.machines.base.SlotWorkbench;
import com.yogpc.qp.machines.workbench.TileWorkbench;
import com.yogpc.qp.utils.Holder;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;

public class ContainerWorkbench
extends Container {
    final TileWorkbench tile;
    private static final int sourceSlot = 27;
    private static final int recipeSlot = 18;
    private static final int playerSlot = 36;
    final IntReferenceHolder progress = this.func_216958_a(IntReferenceHolder.func_221492_a());
    final IntReferenceHolder isWorking = this.func_216958_a(IntReferenceHolder.func_221492_a());
    final IntReferenceHolder workContinue = this.func_216958_a(IntReferenceHolder.func_221492_a());
    final IntReferenceHolder recipeIndex = this.func_216958_a(IntReferenceHolder.func_221492_a());
    final IntReferenceHolder currentEnergy = this.func_216958_a(IntReferenceHolder.func_221492_a());
    final IntReferenceHolder requiredEnergy = this.func_216958_a(IntReferenceHolder.func_221492_a());

    public ContainerWorkbench(int id, PlayerEntity player, BlockPos pos) {
        super(Holder.workbenchContainerType(), id);
        int col;
        int row;
        this.tile = (TileWorkbench)player.func_130014_f_().func_175625_s(pos);
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new SlotUnlimited(this.tile, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        for (row = 0; row < 2; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new SlotWorkbench(this.tile, col + row * 9 + 27, 8 + col * 18, 90 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, col, 8 + col * 18, 198));
        }
        if (!player.field_70170_p.field_72995_K && this.tile != null) {
            this.setTrackValues();
            this.tile.func_174889_b(player);
        }
    }

    private void setTrackValues() {
        this.progress.func_221494_a(this.tile.getProgressScaled(160));
        this.isWorking.func_221494_a(this.tile.isWorking() ? 1 : 0);
        this.workContinue.func_221494_a(this.tile.workContinue ? 1 : 0);
        this.recipeIndex.func_221494_a(this.tile.getRecipeIndex());
        long required = this.recipeIndex.func_221495_b() == -1 ? 0L : this.tile.recipesList.get(this.recipeIndex.func_221495_b()).energy();
        this.requiredEnergy.func_221494_a((int)(required / 100000L));
        this.currentEnergy.func_221494_a(this.tile.getEnergyStored());
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.tile.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        if (27 <= index && index < 45) {
            return ItemStack.field_190927_a;
        }
        ItemStack src = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack remain = slot.func_75211_c();
            src = remain.func_77946_l();
            if (index < 27) {
                if (src.func_77985_e()) {
                    if (!this.func_75135_a(remain, 45, 81, true)) {
                        return ItemStack.field_190927_a;
                    }
                } else {
                    for (int i = 80; i >= 45 && !remain.func_190926_b(); --i) {
                        int maxSize;
                        Slot destinationSlot = (Slot)this.field_75151_b.get(i);
                        if (!destinationSlot.func_75216_d()) {
                            int maxSize2 = Math.min(slot.func_75219_a(), remain.func_77976_d());
                            destinationSlot.func_75215_d(remain.func_77979_a(maxSize2));
                            continue;
                        }
                        ItemStack dest = destinationSlot.func_75211_c();
                        if (!ContainerWorkbench.areStack_Able(dest, remain)) continue;
                        int newSize = dest.func_190916_E() + remain.func_190916_E();
                        if (newSize <= (maxSize = Math.min(slot.func_75219_a(), remain.func_77976_d()))) {
                            remain.func_190920_e(0);
                            dest.func_190920_e(newSize);
                            slot.func_75218_e();
                            continue;
                        }
                        if (dest.func_190916_E() >= maxSize) continue;
                        remain.func_190918_g(maxSize - dest.func_190916_E());
                        dest.func_190920_e(maxSize);
                        slot.func_75218_e();
                    }
                    if (!remain.func_190926_b()) {
                        return ItemStack.field_190927_a;
                    }
                }
            } else if (!this.n_mergeItemStack(remain)) {
                return ItemStack.field_190927_a;
            }
            if (remain.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (remain.func_190916_E() == src.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, remain);
        }
        return src;
    }

    public void func_75142_b() {
        if (this.tile != null) {
            this.setTrackValues();
        }
        super.func_75142_b();
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (27 <= slotId && slotId < 45 && clickTypeIn == ClickType.PICKUP) {
            int index = slotId - 27;
            if (index < this.tile.recipesList.size()) {
                if (dragType == 0) {
                    if (index == this.tile.getRecipeIndex()) {
                        this.tile.workContinue = !this.tile.workContinue;
                    } else {
                        this.tile.setCurrentRecipeIndex(index);
                    }
                } else if (dragType == 1) {
                    this.tile.setCurrentRecipeIndex(-1);
                }
            }
            return ItemStack.field_190927_a;
        }
        if (0 <= slotId && slotId < 27 && clickTypeIn == ClickType.PICKUP) {
            PlayerInventory playerInventory = player.field_71071_by;
            ItemStack itemstack = ItemStack.field_190927_a;
            Slot slot = (Slot)this.field_75151_b.get(slotId);
            if (slot != null) {
                ItemStack slotStack = slot.func_75211_c();
                ItemStack playerStack = playerInventory.func_70445_o();
                if (!slotStack.func_190926_b()) {
                    itemstack = slotStack.func_77946_l();
                }
                if (slotStack.func_190926_b()) {
                    if (!playerStack.func_190926_b() && slot.func_75214_a(playerStack)) {
                        int l2;
                        int n = l2 = dragType == 0 ? playerStack.func_190916_E() : 1;
                        if (l2 > slot.func_178170_b(playerStack)) {
                            l2 = slot.func_178170_b(playerStack);
                        }
                        slot.func_75215_d(playerStack.func_77979_a(l2));
                    }
                } else if (playerStack.func_190926_b()) {
                    int k2 = dragType == 0 ? Math.min(slotStack.func_190916_E(), slotStack.func_77976_d()) : Math.min((slotStack.func_190916_E() + 1) / 2, slotStack.func_77976_d());
                    playerInventory.func_70437_b(slot.func_75209_a(k2));
                    if (slotStack.func_190926_b()) {
                        slot.func_75215_d(ItemStack.field_190927_a);
                    }
                    slot.func_190901_a(player, playerInventory.func_70445_o());
                } else if (ContainerWorkbench.areStack_Able(slotStack, playerStack)) {
                    int j2 = dragType == 0 ? playerStack.func_190916_E() : 1;
                    playerStack.func_190918_g(j2);
                    slotStack.func_190917_f(j2);
                }
                slot.func_75218_e();
            }
            return itemstack;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    protected boolean n_mergeItemStack(ItemStack stack) {
        int i;
        boolean flag = false;
        for (i = 0; i < 27 && !stack.func_190926_b(); ++i) {
            int maxSize;
            Slot slot = (Slot)this.field_75151_b.get(i);
            ItemStack itemstack = slot.func_75211_c();
            if (itemstack.func_190926_b() || !ContainerWorkbench.areStack_Able(stack, itemstack)) continue;
            int j = itemstack.func_190916_E() + stack.func_190916_E();
            if (j <= (maxSize = slot.func_75219_a())) {
                stack.func_190920_e(0);
                itemstack.func_190920_e(j);
                slot.func_75218_e();
                flag = true;
                continue;
            }
            if (itemstack.func_190916_E() >= maxSize) continue;
            if (Config.common().debug()) {
                QuarryPlus.LOGGER.info("ContainerWorkbench#mergeItemStack itemStack.getCount() < maxSize");
            }
            stack.func_190918_g(maxSize - itemstack.func_190916_E());
            itemstack.func_190920_e(maxSize);
            slot.func_75218_e();
            flag = true;
        }
        if (!stack.func_190926_b()) {
            for (i = 0; i < 27; ++i) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                ItemStack itemStack1 = slot1.func_75211_c();
                if (!itemStack1.func_190926_b() || !slot1.func_75214_a(stack)) continue;
                slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                slot1.func_75218_e();
                flag = true;
                break;
            }
        }
        return flag;
    }

    private static boolean areStack_Able(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.tile.func_174886_c(playerIn);
    }
}

