/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.machines.base.IModule;
import com.yogpc.qp.machines.base.QuarryModuleInventory;
import com.yogpc.qp.utils.Holder;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import scala.collection.immutable.List;

public class ContainerQuarryModule
extends Container {
    public static final String GUI_ID = "quarryplus:gui_quarry_module";
    private final QuarryModuleInventory moduleInventory;
    private final int allSlots;
    final HasModuleInventory inventory;

    public ContainerQuarryModule(int id, PlayerEntity player, BlockPos pos) {
        super(Holder.quarryModuleContainerType(), id);
        this.inventory = (HasModuleInventory)player.func_130014_f_().func_175625_s(pos);
        Objects.requireNonNull(this.inventory);
        this.moduleInventory = this.inventory.moduleInv();
        this.allSlots = this.moduleInventory.func_70302_i_();
        int oneBox = 18;
        for (int i = 0; i < this.allSlots; ++i) {
            int verticalFix = i < 5 ? i : i - 5;
            int horizontalFix = i / 5;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.moduleInventory.itemHandler, i, 44 + verticalFix * oneBox, 27 + horizontalFix * oneBox));
        }
        for (int h = 0; h < 3; ++h) {
            for (int v = 0; v < 9; ++v) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, v + h * 9 + 9, 8 + v * oneBox, 84 + h * oneBox));
            }
        }
        for (int vertical = 0; vertical < 9; ++vertical) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, vertical, 8 + vertical * oneBox, 142));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.moduleInventory.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack src = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack remain = slot.func_75211_c();
            src = remain.func_77946_l();
            if (index < this.allSlots ? !this.func_75135_a(remain, this.allSlots, this.allSlots + 36, true) : !this.func_75135_a(remain, 0, this.allSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (remain.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (remain.func_190916_E() == src.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, remain);
        }
        return src;
    }

    public static class InteractionObject
    implements INamedContainerProvider {
        private final BlockPos pos;
        private final String name;

        public InteractionObject(BlockPos pos, String name) {
            this.pos = pos;
            this.name = name;
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent(this.name);
        }

        public Container createMenu(int id, PlayerInventory i, PlayerEntity p) {
            return new ContainerQuarryModule(id, p, this.pos);
        }

        public static <T extends TileEntity> void openGUI(T tile, ServerPlayerEntity player, String name) {
            if (tile.func_145830_o() && !Objects.requireNonNull(tile.func_145831_w()).field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new InteractionObject(tile.func_174877_v(), name), (BlockPos)tile.func_174877_v());
            }
        }
    }

    public static interface HasModuleInventory {
        public QuarryModuleInventory moduleInv();

        public List<IModule> getModules();
    }
}

