/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.modules;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.IDisabled;
import com.yogpc.qp.machines.base.IModule;
import com.yogpc.qp.machines.base.QPItem;
import com.yogpc.qp.machines.modules.IModuleItem;
import com.yogpc.qp.machines.quarry.ContainerQuarryModule;
import com.yogpc.qp.machines.replacer.ReplacerModule;
import com.yogpc.qp.machines.replacer.TileReplacer;
import com.yogpc.qp.utils.Holder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import scala.Function1;
import scala.Symbol;

public class ItemReplacerModule
extends QPItem
implements IDisabled,
IModuleItem {
    public static final String Key_state = "state";

    public ItemReplacerModule() {
        super("replacer_module", (Function1<Item.Properties, Item.Properties>)((Function1)p -> p.func_208103_a(Rarity.UNCOMMON)));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K) {
            if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
                stack.func_196083_e(Key_state);
                context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent("Replacer Module: Setting removed."), Util.field_240973_b_);
            } else {
                if (context.func_195991_k().func_175625_s(context.func_195995_a()) instanceof ContainerQuarryModule.HasModuleInventory) {
                    return ActionResultType.PASS;
                }
                BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
                Predicate<BlockState> deny = TileReplacer.rejects.stream().reduce(MapStreamSyntax.always_false(), Predicate::or);
                if (deny.test(state)) {
                    return ActionResultType.PASS;
                }
                BlockState.field_235877_b_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)state).resultOrPartial(s -> {
                    stack.func_196083_e(Key_state);
                    QuarryPlus.LOGGER.warn("Error in encoding state to NBT. {}, {}", (Object)state, s);
                }).ifPresent(stateTag -> stack.func_77983_a(Key_state, stateTag));
                if (context.func_195999_j() != null) {
                    context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("Replacer Module: %s.", new Object[]{state.func_177230_c().func_235333_g_()}), Util.field_240973_b_);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Optional.ofNullable(stack.func_179543_a(Key_state)).map(c -> new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, c)).flatMap(d -> BlockState.field_235877_b_.parse(d).result()).ifPresent(state -> {
            tooltip.add((ITextComponent)state.func_177230_c().func_235333_g_());
            state.func_206871_b().forEach((k, v) -> tooltip.add((ITextComponent)new StringTextComponent(String.format("  %s: %s", k.func_177701_a(), v))));
        });
    }

    @Override
    public Symbol getSymbol() {
        return Symbol.apply((String)"ModuleReplacer");
    }

    @Override
    public <T extends APowerTile & ContainerQuarryModule.HasModuleInventory> Function<T, IModule> getModule(ItemStack stack) {
        Predicate accept = TileReplacer.rejects.stream().reduce(MapStreamSyntax.always_false(), Predicate::or).negate();
        BlockState state = Optional.ofNullable(stack.func_179543_a(Key_state)).map(c -> new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, c)).flatMap(d -> {
            try {
                return BlockState.field_235877_b_.parse(d).result();
            }
            catch (Exception e) {
                QuarryPlus.LOGGER.debug("Error in getting replace block of ReplaceModule.", (Throwable)e);
                return Optional.empty();
            }
        }).filter(accept).orElse(Holder.blockDummy().func_176223_P());
        return t -> ReplacerModule.apply(state);
    }
}

