/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.HasInv;
import com.yogpc.qp.machines.base.IChunkLoadTile;
import com.yogpc.qp.machines.base.IDebugSender;
import com.yogpc.qp.utils.Holder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class APacketTile
extends TileEntity {
    public static final BinaryOperator<String> combiner = (s, s2) -> s + ", " + s2;
    public static final Function<String, StringTextComponent> toComponentString = StringTextComponent::new;
    public static final Consumer<IChunkLoadTile> requestTicket = IChunkLoadTile::requestTicket;
    private final ITextComponent displayName;
    protected final boolean machineDisabled;
    protected final boolean isDebugSender = this instanceof IDebugSender;
    protected final List<Runnable> startListener = new ArrayList<Runnable>();
    protected final List<Runnable> finishListener = new ArrayList<Runnable>();

    protected APacketTile(TileEntityType<?> type) {
        super(type);
        if (this instanceof HasInv) {
            HasInv hasInv = (HasInv)((Object)this);
            this.displayName = hasInv.func_200200_C_();
        } else if (this.isDebugSender) {
            IDebugSender sender = (IDebugSender)((Object)this);
            this.displayName = new TranslationTextComponent(sender.getDebugName());
        } else {
            this.displayName = new StringTextComponent("APacketTile");
        }
        this.machineDisabled = !((Holder.TileDisable)Holder.tiles().apply(type)).enabled();
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    protected final void startWork() {
        if (this.func_145830_o()) {
            this.startListener.forEach(Runnable::run);
        }
    }

    protected final void finishWork() {
        if (this.func_145830_o()) {
            this.finishListener.forEach(Runnable::run);
        }
    }

    public final boolean enabled() {
        return !this.machineDisabled;
    }

    @SubscribeEvent
    public void releaseChunkLoad(IChunkLoadTile.ReleaseChunkLoadEvent event) {
        World world = this.func_145831_w();
        BlockPos pos = this.func_174877_v();
        if (event.pos.equals((Object)new ChunkPos(pos)) && world != null && event.getWorld() instanceof World && world.func_234923_W_() == ((World)event.getWorld()).func_234923_W_()) {
            event.setCanceled(true);
        }
    }

    public static <T> T invoke(Method method, Class<T> returnType, Object ref, Object ... param) {
        try {
            return returnType.cast(method.invoke(ref, param));
        }
        catch (ReflectiveOperationException e) {
            QuarryPlus.LOGGER.warn((Object)e);
            return null;
        }
    }
}

