/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.marker.packet;

import com.kotori316.marker.Tile16Marker;
import com.kotori316.marker.packet.AreaMessage;
import com.kotori316.marker.packet.PacketHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class Button16Message {
    private BlockPos pos;
    private ResourceLocation dim;
    private int amount;
    private int yMax;
    private int yMin;

    public Button16Message() {
    }

    public Button16Message(BlockPos pos, RegistryKey<World> dim, int amount, int yMax, int yMin) {
        this.pos = pos;
        this.dim = dim.func_240901_a_();
        this.amount = amount;
        this.yMax = yMax;
        this.yMin = yMin;
    }

    public static Button16Message fromBytes(PacketBuffer p) {
        Button16Message message = new Button16Message();
        message.pos = p.func_179259_c();
        message.dim = p.func_192575_l();
        message.amount = p.readInt();
        message.yMax = p.readInt();
        message.yMin = p.readInt();
        return message;
    }

    public void toBytes(PacketBuffer p) {
        p.func_179255_a(this.pos).func_192572_a(this.dim);
        p.writeInt(this.amount);
        p.writeInt(this.yMax).writeInt(this.yMin);
    }

    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Optional.ofNullable(((NetworkEvent.Context)ctx.get()).getSender()).map(Entity::func_130014_f_).map(world -> world.func_175625_s(this.pos)).filter(t -> t instanceof Tile16Marker && PacketHandler.getDimId(t.func_145831_w()).func_240901_a_().equals((Object)this.dim)).ifPresent(entity -> {
            Tile16Marker marker = (Tile16Marker)entity;
            marker.changeSize(this.amount, this.yMax, this.yMin);
            PacketHandler.sendToClient(new AreaMessage(this.pos, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)this.dim), marker.min(), marker.max()), entity.func_145831_w());
        }));
    }
}

