/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.marker.packet;

import com.kotori316.marker.IAreaConfigurable;
import com.kotori316.marker.packet.PacketHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class AreaMessage {
    private BlockPos pos;
    private ResourceLocation dim;
    private BlockPos min;
    private BlockPos max;

    public AreaMessage() {
    }

    public AreaMessage(BlockPos pos, RegistryKey<World> dim, BlockPos min, BlockPos max) {
        this.pos = pos;
        this.dim = dim.func_240901_a_();
        this.min = min;
        this.max = max;
    }

    public static AreaMessage fromBytes(PacketBuffer p) {
        AreaMessage message = new AreaMessage();
        message.pos = p.func_179259_c();
        message.dim = p.func_192575_l();
        message.min = p.func_179259_c();
        message.max = p.func_179259_c();
        return message;
    }

    public void toBytes(PacketBuffer p) {
        p.func_179255_a(this.pos).func_192572_a(this.dim);
        p.func_179255_a(this.min).func_179255_a(this.max);
    }

    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        Optional.ofNullable(Minecraft.func_71410_x().field_71441_e).map(world -> world.func_175625_s(this.pos)).filter(t -> t instanceof IAreaConfigurable && PacketHandler.getDimId(t.func_145831_w()) == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)this.dim)).ifPresent(entity -> {
            IAreaConfigurable marker = (IAreaConfigurable)entity;
            ((NetworkEvent.Context)ctx.get()).enqueueWork(marker.setMinMax(this.min, this.max));
        });
        ctx.get().setPacketHandled(true);
    }
}

