/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.marker;

import com.kotori316.marker.Caps;
import com.kotori316.marker.Marker;
import com.mojang.serialization.DynamicOps;
import com.yogpc.qp.machines.base.Area;
import com.yogpc.qp.machines.base.IMarker;
import com.yogpc.qp.machines.base.IRemotePowerOn;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteControlItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger(RemoteControlItem.class);
    public static final String NBT_AREA = "area";
    public static final String NBT_REMOTE_POS = "remote_pos";
    public static final String NAME = "remote_controller";
    public static final Function<GlobalPos, ITextComponent> convertPosText = p -> new TranslationTextComponent("tooltip.flexiblemarker.remote_pos", new Object[]{p.func_218180_b().func_177958_n(), p.func_218180_b().func_177956_o(), p.func_218180_b().func_177952_p(), p.func_239646_a_().func_240901_a_()});

    public RemoteControlItem() {
        super(new Item.Properties().func_200916_a((ItemGroup)Marker.ITEM_GROUP));
        this.setRegistryName("quarryplus", NAME);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (Caps.isQuarryModLoaded()) {
            World world = context.func_195991_k();
            if (world.field_72995_K) {
                return ActionResultType.PASS;
            }
            TileEntity tileEntity = world.func_175625_s(context.func_195995_a());
            if (tileEntity != null) {
                Optional<Area> maybeMarker = Caps.markerCapability().flatMap(c -> tileEntity.getCapability(c, context.func_196000_l()).filter(IMarker::hasLink));
                Optional maybeRemoteControllable = Caps.remotePowerOnCapability().flatMap(c -> tileEntity.getCapability(c, context.func_196000_l()).resolve());
                if (maybeMarker.isPresent()) {
                    if (world.func_73046_m() != null) {
                        maybeMarker.map(m -> Area.posToArea((Vector3i)m.min(), (Vector3i)m.max(), (RegistryKey<World>)world.func_234923_W_())).ifPresent(area -> {
                            RemoteControlItem.setArea(stack, (CompoundNBT)Area.areaToNbt().apply(area));
                            LOGGER.debug("New area set: {}", area);
                            maybeMarker.ifPresent(m -> m.removeFromWorldWithItem().forEach(i -> {
                                if (context.func_195999_j() != null && !context.func_195999_j().field_71071_by.func_70441_a(i)) {
                                    context.func_195999_j().func_71019_a(i, false);
                                }
                            }));
                            RemoteControlItem.getRemotePos(stack).flatMap(p -> Optional.ofNullable(world.func_73046_m()).map(w -> w.func_71218_a(p.func_239646_a_())).map(w -> w.func_175625_s(p.func_218180_b()))).flatMap(t -> Caps.remotePowerOnCapability().map(c -> t.getCapability(c, context.func_196000_l()))).ifPresent(l -> l.ifPresent(r -> {
                                LOGGER.debug("Send start request to {} with {}", r, area);
                                r.setAndStart((Area)area);
                                stack.func_196083_e(NBT_AREA);
                            }));
                        });
                        Optional.ofNullable(context.func_195999_j()).ifPresent(p -> p.func_146105_b((ITextComponent)new TranslationTextComponent("chat.flexiblemarker.area"), false));
                    }
                    return ActionResultType.SUCCESS;
                }
                if (maybeRemoteControllable.isPresent()) {
                    Optional<Area> optionalArea = RemoteControlItem.getArea(stack);
                    if (optionalArea.isPresent()) {
                        maybeRemoteControllable.ifPresent(r -> {
                            r.setAndStart((Area)optionalArea.get());
                            LOGGER.debug("Send start request to {} with {}", r, optionalArea.get());
                            stack.func_196083_e(NBT_AREA);
                        });
                    } else {
                        GlobalPos pos = GlobalPos.func_239648_a_((RegistryKey)world.func_234923_W_(), (BlockPos)tileEntity.func_174877_v());
                        RemoteControlItem.setRemotePos(stack, pos);
                        LOGGER.debug("New remote pos set {}.", (Object)pos);
                        Optional.ofNullable(context.func_195999_j()).ifPresent(p -> p.func_146105_b((ITextComponent)new TranslationTextComponent("chat.flexiblemarker.pos", new Object[]{convertPosText.apply(pos)}), false));
                        maybeRemoteControllable.ifPresent(IRemotePowerOn::startWaiting);
                    }
                    return ActionResultType.SUCCESS;
                }
                return super.onItemUseFirst(stack, context);
            }
            if (context.func_225518_g_() && stack.func_77942_o()) {
                stack.func_196083_e(NBT_REMOTE_POS);
                stack.func_196083_e(NBT_AREA);
                LOGGER.debug("Reset controller setting.");
                Optional.ofNullable(context.func_195999_j()).ifPresent(p -> p.func_146105_b((ITextComponent)new TranslationTextComponent("chat.flexiblemarker.reset"), false));
                return ActionResultType.SUCCESS;
            }
            return super.onItemUseFirst(stack, context);
        }
        return super.onItemUseFirst(stack, context);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(RemoteControlItem.areaText(stack));
        tooltip.addAll(RemoteControlItem.remotePosText(stack));
    }

    public static List<? extends ITextComponent> areaText(ItemStack stack) {
        if (Caps.isQuarryModLoaded()) {
            return RemoteControlItem.getArea(stack).map(AreaComponent.convertAreaText).map(Collections::singletonList).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public static Optional<Area> getArea(ItemStack stack) {
        if (Caps.isQuarryModLoaded() && !stack.func_190926_b()) {
            return AreaComponent.getAreaInternal(stack);
        }
        return Optional.empty();
    }

    public static void setArea(ItemStack stack, CompoundNBT areaNBT) {
        stack.func_77983_a(NBT_AREA, (INBT)areaNBT);
    }

    public static List<? extends ITextComponent> remotePosText(ItemStack stack) {
        return RemoteControlItem.getRemotePos(stack).map(convertPosText).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    public static Optional<GlobalPos> getRemotePos(ItemStack stack) {
        if (Caps.isQuarryModLoaded() && !stack.func_190926_b()) {
            return Optional.ofNullable(stack.func_77978_p()).filter(t -> t.func_74764_b(NBT_REMOTE_POS)).filter(t -> !t.func_150297_b(NBT_REMOTE_POS, 4)).flatMap(t -> GlobalPos.field_239645_a_.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)t.func_74781_a(NBT_REMOTE_POS)).result());
        }
        return Optional.empty();
    }

    public static void setRemotePos(ItemStack stack, GlobalPos pos) {
        GlobalPos.field_239645_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)pos).result().ifPresent(p -> stack.func_77983_a(NBT_REMOTE_POS, p));
    }

    private static class AreaComponent {
        public static final Function<Area, ITextComponent> convertAreaText = a -> new TranslationTextComponent("tooltip.flexiblemarker.area", new Object[]{a.xMin(), a.yMin(), a.zMin(), a.xMax(), a.yMax(), a.zMax()});

        private AreaComponent() {
        }

        private static Optional<Area> getAreaInternal(ItemStack stack) {
            return Optional.ofNullable(stack.func_179543_a(RemoteControlItem.NBT_AREA)).map(Area::areaLoad);
        }
    }
}

