/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.marker;

import com.kotori316.marker.Marker;
import com.kotori316.marker.Range;
import com.kotori316.marker.Tile16Marker;
import com.kotori316.marker.TileFlexMarker;
import com.kotori316.marker.gui.ContainerMarker;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class BlockMarker
extends Block {
    private static final VoxelShape STANDING_Shape = VoxelShapes.func_197873_a((double)0.35, (double)0.0, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    public final BlockItem itemBlock;
    public static final String GUI_ID = "quarryplus:gui_marker";
    public static final String GUI16_ID = "quarryplus:gui_marker16";

    public BlockMarker(String name) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q));
        this.setRegistryName("quarryplus", name);
        this.itemBlock = new BlockItem((Block)this, new Item.Properties().func_200916_a((ItemGroup)Marker.ITEM_GROUP));
        this.itemBlock.setRegistryName("quarryplus", name);
    }

    protected abstract void openGUI(World var1, BlockPos var2, PlayerEntity var3);

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_213453_ef()) {
            if (!worldIn.field_72995_K) {
                this.openGUI(worldIn, pos, player);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return true;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return STANDING_Shape;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = Direction.UP;
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        BlockState floorState = worldIn.func_180495_p(blockpos);
        return floorState.func_224755_d((IBlockReader)worldIn, blockpos, direction);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public abstract void func_180633_a(World var1, BlockPos var2, BlockState var3, LivingEntity var4, ItemStack var5);

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public abstract TileEntity createTileEntity(BlockState var1, IBlockReader var2);

    private static class InteractionObject
    implements INamedContainerProvider {
        private final BlockPos pos;
        private final ContainerType<?> type;
        private final String name;

        public InteractionObject(BlockPos pos, ContainerType<?> type, String name) {
            this.pos = pos;
            this.type = type;
            this.name = name;
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent(this.name);
        }

        public Container createMenu(int id, PlayerInventory p_createMenu_2_, PlayerEntity playerIn) {
            return new ContainerMarker(id, playerIn, this.pos, this.type);
        }
    }

    public static class Block16Marker
    extends BlockMarker {
        private static final Range RANGE = new Range(0.0f, 360.0f);

        public Block16Marker() {
            super("marker16");
        }

        @Override
        protected void openGUI(World worldIn, BlockPos pos, PlayerEntity playerIn) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new InteractionObject(pos, Marker.Entries.CONTAINER16_TYPE, this.func_149739_a()), (BlockPos)pos);
        }

        @Override
        public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            float angle = RANGE.convert(placer != null ? placer.func_70079_am() : 0.0f);
            Direction.AxisDirection z = angle < 90.0f || angle >= 270.0f ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
            Direction.AxisDirection x = angle > 180.0f ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
            Optional.ofNullable((Tile16Marker)worldIn.func_175625_s(pos)).ifPresent(t -> t.init(x, z));
        }

        @Override
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return Marker.Entries.TYPE16.func_200968_a();
        }
    }

    public static class BlockFlexMarker
    extends BlockMarker {
        public static final String NAME = "flex_marker";

        public BlockFlexMarker() {
            super(NAME);
        }

        @Override
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return Marker.Entries.TYPE.func_200968_a();
        }

        @Override
        protected void openGUI(World worldIn, BlockPos pos, PlayerEntity playerIn) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new InteractionObject(pos, Marker.Entries.CONTAINER_TYPE, this.func_149739_a()), (BlockPos)pos);
        }

        @Override
        public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            float rotationYawHead = placer != null ? placer.func_70079_am() : 0.0f;
            Optional.ofNullable((TileFlexMarker)worldIn.func_175625_s(pos)).ifPresent(t -> t.init(Direction.func_176733_a((double)rotationYawHead)));
        }
    }
}

