/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.client.utils.GuiUtils;
import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.EtrionicBlastFurnaceMenu;
import earth.terrarium.adastra.common.recipes.machines.AlloyingRecipe;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import earth.terrarium.adastra.common.utils.ItemUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3859;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EtrionicBlastFurnaceBlockEntity
extends EnergyContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_SLOTS), new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY));
    @Nullable
    private AlloyingRecipe alloyingRecipe;
    protected final class_1863.class_7266<class_1263, AlloyingRecipe> alloyingQuickCheck = class_1863.method_42302((class_3956)((class_3956)ModRecipeTypes.ALLOYING.get()));
    private final class_3859[] recipes = new class_3859[4];
    private Mode mode = Mode.BLASTING;
    protected int cookTime;
    protected int cookTimeTotal;

    public EtrionicBlastFurnaceBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, 9);
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new EtrionicBlastFurnaceMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachineConfig.steelTierEnergyCapacity, MachineConfig.steelTierMaxEnergyInOut));
        return this.energyContainer;
    }

    @Override
    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        if (this.canFunction()) {
            this.recipeTick(this.getEnergyStorage());
        }
        if (time % 5L == 0L) {
            this.setLit(this.cookTimeTotal > 0 && this.canFunction());
        }
    }

    @Override
    public boolean shouldUpdate() {
        for (int i = 0; i < 4; ++i) {
            if (this.recipes[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pullItemsNearby(this, pos, new int[]{1, 2, 3, 4}, sideConfig.get(0), filter);
        TransferUtils.pushItemsNearby(this, pos, new int[]{5, 6, 7, 8}, sideConfig.get(1), filter);
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(2), filter);
    }

    public void recipeTick(WrappedBlockEnergyContainer energyStorage) {
        int i;
        if (this.mode == Mode.ALLOYING) {
            this.alloyingRecipeTick(energyStorage);
            return;
        }
        boolean isCooking = false;
        boolean shouldClear = true;
        for (i = 0; i < 4; ++i) {
            if (this.recipes[i] == null) continue;
            if (this.canCraft(energyStorage, this.recipes[i], i + 1)) {
                shouldClear = false;
            }
            energyStorage.internalExtract(MachineConfig.etrionicBlastFurnaceBlastingEnergyPerItem, false);
            isCooking = true;
            if (this.cookTime < this.cookTimeTotal) continue;
            for (int j = 0; j < 4; ++j) {
                this.craft(this.recipes[j], j, j + 1);
            }
        }
        if (isCooking) {
            ++this.cookTime;
        }
        if (shouldClear) {
            for (i = 0; i < 4; ++i) {
                this.clearRecipe(i);
            }
        }
    }

    protected boolean canCraft(WrappedBlockEnergyContainer energyStorage, class_3859 recipe, int slot) {
        if (recipe == null) {
            return false;
        }
        if (energyStorage.internalExtract(MachineConfig.etrionicBlastFurnaceBlastingEnergyPerItem, true) < MachineConfig.etrionicBlastFurnaceBlastingEnergyPerItem) {
            return false;
        }
        if (!((class_1856)recipe.method_8117().get(0)).method_8093(this.method_5438(slot))) {
            return false;
        }
        return ItemUtils.canAddItem(this, recipe.method_8110(this.level().method_30349()), 5, 6, 7, 8);
    }

    protected void craft(class_3859 recipe, int recipeIndex, int slot) {
        if (recipe == null) {
            return;
        }
        this.method_5438(slot).method_7934(1);
        ItemUtils.addItem((class_1263)this, recipe.method_8110(this.level().method_30349()), 5, 6, 7, 8);
        this.cookTime = 0;
        if (this.method_5438(slot).method_7960()) {
            this.clearRecipe(recipeIndex);
        }
    }

    public void alloyingRecipeTick(WrappedBlockEnergyContainer energyStorage) {
        if (this.alloyingRecipe == null) {
            return;
        }
        if (!this.canCraftAlloying()) {
            this.clearAlloyingRecipe();
            return;
        }
        energyStorage.internalExtract((long)this.alloyingRecipe.energy(), false);
        ++this.cookTime;
        if (this.cookTime < this.cookTimeTotal) {
            return;
        }
        this.craftAlloying();
    }

    public boolean canCraftAlloying() {
        return this.alloyingRecipe != null && this.alloyingRecipe.method_8115(this, this.level());
    }

    public void craftAlloying() {
        if (this.alloyingRecipe == null) {
            return;
        }
        block0: for (class_1856 recipe : this.alloyingRecipe.ingredients()) {
            for (int i = 0; i < 4; ++i) {
                if (!recipe.method_8093(this.method_5438(i + 1))) continue;
                this.method_5438(i + 1).method_7934(1);
                continue block0;
            }
        }
        ItemUtils.addItem((class_1263)this, this.alloyingRecipe.result(), 5, 6, 7, 8);
        this.cookTime = 0;
        if (!this.canCraftAlloying()) {
            this.clearAlloyingRecipe();
        }
    }

    @Override
    public void update() {
        if (this.level().method_8608()) {
            return;
        }
        if (this.mode == Mode.BLASTING) {
            for (int i = 0; i < 4; ++i) {
                this.createRecipe(i, i + 1);
            }
        } else {
            this.alloyingQuickCheck.method_42303((class_1263)this, this.level()).ifPresent(r -> {
                this.alloyingRecipe = r;
                this.cookTimeTotal = r.cookingTime();
            });
        }
    }

    @Nullable
    protected void createRecipe(int recipe, int slot) {
        if (this.method_5438(slot).method_7960()) {
            return;
        }
        this.level().method_8433().method_30027(class_3956.field_17547).stream().filter(r -> ((class_1856)r.method_8117().get(0)).method_8093(this.method_5438(slot))).findFirst().ifPresent(r -> {
            this.recipes[recipe] = r;
            this.cookTimeTotal = r.method_8167();
        });
    }

    @Override
    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.cookTime = tag.method_10550("CookTime");
        this.cookTimeTotal = tag.method_10550("CookTimeTotal");
        this.mode = Mode.values()[tag.method_10571("Mode")];
    }

    @Override
    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("CookTime", this.cookTime);
        tag.method_10569("CookTimeTotal", this.cookTimeTotal);
        tag.method_10567("Mode", (byte)this.mode.ordinal());
    }

    public void clearRecipe(int recipe) {
        this.recipes[recipe] = null;
        this.cookTime = 0;
        this.cookTimeTotal = 0;
    }

    public void clearAlloyingRecipe() {
        this.alloyingRecipe = null;
        this.cookTime = 0;
        this.cookTimeTotal = 0;
    }

    public int cookTime() {
        return this.cookTime;
    }

    public int cookTimeTotal() {
        return this.cookTimeTotal;
    }

    public Mode mode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    }

    public static enum Mode {
        ALLOYING(GuiUtils.CRAFTING_BUTTON),
        BLASTING(GuiUtils.FURNACE_BUTTON);

        private final class_2960 icon;

        private Mode(class_2960 icon) {
            this.icon = icon;
        }

        public class_2960 icon() {
            return this.icon;
        }

        public class_2561 translation() {
            return class_2561.method_43471((String)"tooltip.ad_astra.etrionic_blast_furnace.mode.%s".formatted(this.name().toLowerCase(Locale.ROOT)));
        }

        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }

        public Mode previous() {
            return Mode.values()[(this.ordinal() - 1 + Mode.values().length) % Mode.values().length];
        }
    }
}

