/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.base.sideconfig;

import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public record ConfigurationEntry(ConfigurationType type, EnumMap<class_2350, Configuration> sides, class_2561 title) {
    public ConfigurationEntry(ConfigurationType type, Configuration defaultValue, class_2561 title) {
        this(type, ConfigurationEntry.createConfiguration(defaultValue), title);
    }

    public Configuration get(class_2350 direction) {
        return this.sides.get(direction);
    }

    public void set(class_2350 direction, Configuration value) {
        this.sides.replace(direction, value);
    }

    public ConfigurationEntry copy() {
        return new ConfigurationEntry(this.type, new EnumMap<class_2350, Configuration>(this.sides), this.title);
    }

    public static void save(class_2487 tag, List<ConfigurationEntry> sideConfig) {
        class_2499 list = new class_2499();
        for (ConfigurationEntry entry : sideConfig) {
            class_2487 entryTag = new class_2487();
            entryTag.method_10567("Type", (byte)entry.type.ordinal());
            entry.sides.forEach((direction, configuration) -> entryTag.method_10567(direction.method_10151(), (byte)configuration.ordinal()));
            list.add((Object)entryTag);
        }
        tag.method_10566("SideConfig", (class_2520)list);
    }

    public static void load(class_2487 tag, List<ConfigurationEntry> sideConfig, List<ConfigurationEntry> defaultConfig) {
        class_2499 list = tag.method_10554("SideConfig", 10);
        sideConfig.clear();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 entryTag = list.method_10602(i);
            ConfigurationType type = ConfigurationType.values()[entryTag.method_10571("Type")];
            EnumMap<class_2350, Configuration> sides = new EnumMap<class_2350, Configuration>(class_2350.class);
            for (class_2350 direction : class_2350.values()) {
                sides.put(direction, Configuration.values()[entryTag.method_10571(direction.method_10151())]);
            }
            sideConfig.add(new ConfigurationEntry(type, sides, defaultConfig.get(i).title()));
        }
    }

    private static EnumMap<class_2350, Configuration> createConfiguration(Configuration value) {
        EnumMap<class_2350, Configuration> configurations = new EnumMap<class_2350, Configuration>(class_2350.class);
        for (class_2350 direction : class_2350.values()) {
            configurations.put(direction, value);
        }
        return configurations;
    }
}

