/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.base;

import earth.terrarium.adastra.common.blockentities.base.BasicContainer;
import earth.terrarium.adastra.common.blockentities.base.MachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.RedstoneControl;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.SideConfigurable;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerMachineBlockEntity
extends MachineBlockEntity
implements BasicContainer,
class_1278,
ExtraDataMenuProvider,
SideConfigurable {
    private final List<ConfigurationEntry> sideConfig = new ArrayList<ConfigurationEntry>();
    private final class_2371<class_1799> items;
    private RedstoneControl redstoneControl = RedstoneControl.ALWAYS_ON;

    public ContainerMachineBlockEntity(class_2338 pos, class_2680 state, int containerSize) {
        super(pos, state);
        this.items = class_2371.method_10213((int)containerSize, (Object)class_1799.field_8037);
    }

    @Override
    public void firstTick(class_1937 level, class_2338 pos, class_2680 state) {
        super.firstTick(level, pos, state);
        this.update();
    }

    @Override
    public void internalServerTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        if (time % 50L == 0L && this.shouldUpdate()) {
            this.update();
        }
        if (this.canFunction()) {
            this.tickSideInteractions(pos, f -> true, this.getSideConfig());
        }
    }

    public boolean shouldUpdate() {
        return true;
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        class_1262.method_5429((class_2487)tag, this.items);
        ConfigurationEntry.load(tag, this.sideConfig, this.getDefaultConfig());
        this.redstoneControl = RedstoneControl.values()[tag.method_10571("RedstoneControl")];
    }

    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
        ConfigurationEntry.save(tag, this.sideConfig);
        tag.method_10567("RedstoneControl", (byte)this.redstoneControl.ordinal());
    }

    public void writeExtraData(class_3222 player, class_2540 buffer) {
        buffer.method_10807(this.method_11016());
    }

    public boolean method_5443(@NotNull class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    @NotNull
    public class_2561 method_5476() {
        return this.method_11010().method_26204().method_9518();
    }

    @Override
    public class_2371<class_1799> items() {
        return this.items;
    }

    public boolean canFunction() {
        return this.getRedstoneControl().canPower(this.isRedstonePowered());
    }

    @Override
    public List<ConfigurationEntry> getSideConfig() {
        if (this.sideConfig.isEmpty()) {
            this.sideConfig.addAll(this.createDefaultConfig());
        }
        return this.sideConfig;
    }

    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
    }

    public RedstoneControl getRedstoneControl() {
        return this.redstoneControl;
    }

    public void setRedstoneControl(RedstoneControl redstoneControl) {
        this.redstoneControl = redstoneControl;
        this.method_5431();
    }

    public boolean method_5492(int index, @NotNull class_1799 itemStack, @Nullable class_2350 direction) {
        return true;
    }

    public boolean method_5493(int index, @NotNull class_1799 stack, @NotNull class_2350 direction) {
        return true;
    }
}

