/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.api.planets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.adastra.common.planets.AdAstraData;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public record Planet(class_5321<class_1937> dimension, boolean oxygen, short temperature, float gravity, int solarPower, class_2960 solarSystem, Optional<class_5321<class_1937>> orbit, int tier, List<class_5321<class_1937>> additionalLaunchDimensions) {
    public static final class_5321<class_1937> EARTH_ORBIT = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "earth_orbit"));
    public static final class_5321<class_1937> MOON_ORBIT = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "moon_orbit"));
    public static final class_5321<class_1937> MARS_ORBIT = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "mars_orbit"));
    public static final class_5321<class_1937> VENUS_ORBIT = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "venus_orbit"));
    public static final class_5321<class_1937> MERCURY_ORBIT = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "mercury_orbit"));
    public static final class_5321<class_1937> GLACIO_ORBIT = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "glacio_orbit"));
    public static final class_5321<class_1937> MOON = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "moon"));
    public static final class_5321<class_1937> MARS = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "mars"));
    public static final class_5321<class_1937> VENUS = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "venus"));
    public static final class_5321<class_1937> MERCURY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "mercury"));
    public static final class_5321<class_1937> GLACIO = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "glacio"));
    public static final Codec<Planet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41223).fieldOf("dimension").forGetter(Planet::dimension), (App)Codec.BOOL.fieldOf("oxygen").forGetter(Planet::oxygen), (App)Codec.SHORT.fieldOf("temperature").forGetter(Planet::temperature), (App)Codec.FLOAT.fieldOf("gravity").forGetter(Planet::gravity), (App)Codec.INT.fieldOf("solar_power").forGetter(Planet::solarPower), (App)class_2960.field_25139.fieldOf("solar_system").forGetter(Planet::solarSystem), (App)class_5321.method_39154((class_5321)class_7924.field_41223).optionalFieldOf("orbit").forGetter(Planet::orbit), (App)Codec.INT.fieldOf("tier").forGetter(Planet::tier), (App)class_5321.method_39154((class_5321)class_7924.field_41223).listOf().optionalFieldOf("additional_launch_dimensions", List.of()).forGetter(Planet::additionalLaunchDimensions)).apply((Applicative)instance, Planet::new));

    public class_5321<class_1937> orbitIfPresent() {
        return this.orbit.orElse(this.dimension);
    }

    public boolean isSpace() {
        return this.orbit.isEmpty();
    }

    public Optional<class_5321<class_1937>> getOrbitPlanet() {
        for (Planet planet : AdAstraData.planets().values()) {
            if (planet.orbit().isEmpty() || !planet.orbit().get().equals(this.dimension)) continue;
            return Optional.of(planet.dimension());
        }
        return Optional.empty();
    }
}

