/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.entity;

import ad_astra_giselle_addon.common.entity.LivingHelperDelegate;
import ad_astra_giselle_addon.common.item.ItemStackConsumers;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;

public class LivingHelper {
    private static final Delegate DELEGATE = new LivingHelperDelegate();

    public static boolean isPlayingMode(class_1309 living) {
        if (living instanceof class_1657) {
            class_1657 player = (class_1657)living;
            return !player.method_7337() && !player.method_7325();
        }
        return true;
    }

    public static List<ItemStackReference> getSlotItems(class_1309 living) {
        ArrayList<ItemStackReference> list = new ArrayList<ItemStackReference>();
        for (class_1268 hand : class_1268.values()) {
            list.add(LivingHelper.getHandItem(living, hand));
        }
        list.addAll(LivingHelper.getEquipmentItems(living));
        list.addAll(DELEGATE.getExtraSlotItems(living));
        return list;
    }

    public static ItemStackReference getHandItem(class_1309 living, class_1268 hand) {
        return new ItemStackReference(living.method_5998(hand), ItemStackConsumers.hand(hand, (arg_0, arg_1) -> ((class_1309)living).method_6122(arg_0, arg_1)));
    }

    public static List<ItemStackReference> getEquipmentItems(class_1309 living) {
        ArrayList<ItemStackReference> list = new ArrayList<ItemStackReference>();
        for (class_1304 slot : class_1304.values()) {
            list.add(LivingHelper.getEquipmentItem(living, slot));
        }
        return list;
    }

    public static ItemStackReference getEquipmentItem(class_1309 living, class_1304 slot) {
        return new ItemStackReference(living.method_6118(slot), ItemStackConsumers.equipment(slot, (arg_0, arg_1) -> ((class_1309)living).method_5673(arg_0, arg_1)));
    }

    public static List<ItemStackReference> getInventoryItems(class_1309 living) {
        ArrayList<ItemStackReference> list = new ArrayList<ItemStackReference>();
        if (living instanceof class_1657) {
            class_1657 player = (class_1657)living;
            class_1661 inventory = player.method_31548();
            int size = inventory.method_5439();
            for (int i = 0; i < size; ++i) {
                class_1799 item = inventory.method_5438(i);
                if (item.method_7960()) continue;
                list.add(LivingHelper.getInventoryitem(inventory, i));
            }
            list.addAll(DELEGATE.getExtraSlotItems(living));
        } else {
            list.addAll(LivingHelper.getSlotItems(living));
        }
        return list;
    }

    public static ItemStackReference getInventoryitem(class_1661 inventory, int i) {
        return new ItemStackReference(inventory.method_5438(i), ItemStackConsumers.index(i, (arg_0, arg_1) -> ((class_1661)inventory).method_5447(arg_0, arg_1)));
    }

    public static interface Delegate {
        default public List<ItemStackReference> getExtraSlotItems(class_1309 living) {
            return Collections.emptyList();
        }
    }
}

