/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenChargerItem;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.FluidUtils2;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.items.ZipGunItem;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public class OxygenChargerUtils {
    public static final long LEAST_DISTRIBUTION_AMOUNT = FluidConstants.fromMillibuckets((long)1L);

    public static void distributeToItems(class_1309 living) {
        OxygenChargerUtils.streamExtractable(living, LEAST_DISTRIBUTION_AMOUNT).forEach(c -> OxygenChargerUtils.distributeToItems(living, c));
    }

    public static void distributeToItems(class_1309 living, IOxygenCharger oxygenCharger) {
        FluidHolder moved;
        ItemFluidContainer itemFluidContainer;
        ItemStackReference itemRef;
        class_1792 item;
        FluidContainer fluidContainer = oxygenCharger.getFluidContainer();
        List<ItemStackReference> items = oxygenCharger.getChargeMode().getItems(living);
        long transfer = oxygenCharger.getTransferAmount();
        Iterator iterator = items.iterator();
        while (iterator.hasNext() && (!((item = (itemRef = (ItemStackReference)((Object)iterator.next())).getStack().method_7909()) instanceof SpaceSuitItem) && !(item instanceof ZipGunItem) || (itemFluidContainer = FluidContainer.of((ItemStackHolder)itemRef)) == null || (moved = FluidUtils2.moveFluidAny(fluidContainer, (FluidContainer)itemFluidContainer, FluidPredicates::isOxygen, transfer, false)).isEmpty() || (transfer -= moved.getFluidAmount()) > 0L)) {
        }
    }

    public static OptionalDouble getExtractableStoredRatio(class_1309 living) {
        List<ItemStackReference> items = LivingHelper.getInventoryItems(living);
        long stored = 0L;
        long capacity = 0L;
        class_1937 level = living.method_37908();
        class_2338 pos = living.method_24515();
        boolean isCold = TemperatureApi.API.isCold(level, pos);
        boolean isHot = TemperatureApi.API.isHot(level, pos);
        for (ItemStackReference item : items) {
            IOxygenCharger oxygenCharger = OxygenChargerUtils.get(item);
            if (oxygenCharger == null || !oxygenCharger.canUse(isCold, isHot)) continue;
            stored += oxygenCharger.getTotalAmount();
            capacity += oxygenCharger.getTotalCapacity();
        }
        if (capacity == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((double)stored / (double)capacity);
    }

    @Nullable
    public static IOxygenCharger firstExtractable(class_1309 living, long extracting) {
        return OxygenChargerUtils.streamExtractable(living, extracting).findFirst().orElse(null);
    }

    @Nullable
    public static Stream<IOxygenCharger> streamExtractable(class_1309 living, long extracting) {
        class_1937 level = living.method_37908();
        class_2338 pos = living.method_24515();
        boolean isCold = TemperatureApi.API.isCold(level, pos);
        boolean isHot = TemperatureApi.API.isHot(level, pos);
        return LivingHelper.getInventoryItems(living).stream().map(OxygenChargerUtils::get).filter(oxygenCharger -> {
            FluidHolder extract;
            return oxygenCharger != null && oxygenCharger.canUse(isCold, isHot) && !(extract = FluidUtils2.extractFluid(oxygenCharger.getFluidContainer(), FluidPredicates::isOxygen, extracting, true)).isEmpty() && extract.getFluidAmount() >= extracting;
        });
    }

    @Nullable
    public static IOxygenCharger get(ItemStackHolder item) {
        class_1792 class_17922 = item.getStack().method_7909();
        if (class_17922 instanceof IOxygenChargerItem) {
            IOxygenChargerItem oxygenChargerItem = (IOxygenChargerItem)class_17922;
            return oxygenChargerItem.getOxygenCharger(item);
        }
        return null;
    }

    private OxygenChargerUtils() {
    }
}

