/*
 * Decompiled with CFR 0.152.
 */
package audaki.cart_engine.mixin;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2442;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1688.class})
public abstract class AbstractMinecartEntityMixin
extends class_1297 {
    public AbstractMinecartEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    protected abstract boolean method_18803(class_2338 var1);

    @Shadow
    public abstract class_243 method_7508(double var1, double var3, double var5);

    @Shadow
    protected abstract void method_7525();

    @Shadow
    protected abstract double method_7504();

    @Shadow
    protected abstract class_1688.class_1689 method_7518();

    @Shadow
    private static Pair<class_2382, class_2382> method_22864(class_2768 shape) {
        return Pair.of((Object)class_2350.field_11043.method_10163(), (Object)class_2350.field_11035.method_10163());
    }

    private static boolean isEligibleFastRail(class_2680 state) {
        return state.method_27852(class_2246.field_10167) || state.method_27852(class_2246.field_10425) && (Boolean)state.method_11654((class_2769)class_2442.field_11364) != false;
    }

    private static class_2768 getRailShape(class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof class_2241)) {
            throw new IllegalArgumentException("No rail shape found");
        }
        class_2241 railBlock = (class_2241)class_22482;
        return (class_2768)state.method_11654(railBlock.method_9474());
    }

    @Inject(at={@At(value="HEAD")}, method={"moveOnRail"}, cancellable=true)
    protected void moveOnRailOverwrite(class_2338 pos, class_2680 state, CallbackInfo ci) {
        if (this.method_7518() != class_1688.class_1689.field_7674) {
            return;
        }
        boolean hasLivingRider = this.method_31483() instanceof class_1309;
        if (!hasLivingRider) {
            return;
        }
        this.modifiedMoveOnRail(pos, state);
        ci.cancel();
    }

    protected void modifiedMoveOnRail(class_2338 pos, class_2680 state) {
        double af;
        class_243 vec3d7;
        double w;
        double v;
        double x;
        this.method_38785();
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        class_243 vec3d = this.method_7508(d, e, f);
        e = pos.method_10264();
        boolean onPoweredRail = false;
        boolean onBrakeRail = false;
        if (state.method_27852(class_2246.field_10425)) {
            onPoweredRail = (Boolean)state.method_11654((class_2769)class_2442.field_11364);
            onBrakeRail = !onPoweredRail;
        }
        double g = 0.0078125;
        if (this.method_5799()) {
            g *= 0.2;
        }
        class_243 velocity = this.method_18798();
        class_2768 railShape = AbstractMinecartEntityMixin.getRailShape(state);
        switch (railShape) {
            case field_12667: {
                this.method_18799(velocity.method_1031(-g, 0.0, 0.0));
                e += 1.0;
                break;
            }
            case field_12666: {
                this.method_18799(velocity.method_1031(g, 0.0, 0.0));
                e += 1.0;
                break;
            }
            case field_12670: {
                this.method_18799(velocity.method_1031(0.0, 0.0, g));
                e += 1.0;
                break;
            }
            case field_12668: {
                this.method_18799(velocity.method_1031(0.0, 0.0, -g));
                e += 1.0;
            }
        }
        velocity = this.method_18798();
        Pair<class_2382, class_2382> adjacentRailPositions = AbstractMinecartEntityMixin.method_22864(railShape);
        class_2382 adjacentRail1RelPos = (class_2382)adjacentRailPositions.getFirst();
        class_2382 adjacentRail2RelPos = (class_2382)adjacentRailPositions.getSecond();
        double h = adjacentRail2RelPos.method_10263() - adjacentRail1RelPos.method_10263();
        double i = adjacentRail2RelPos.method_10260() - adjacentRail1RelPos.method_10260();
        double j = Math.sqrt(h * h + i * i);
        double k = velocity.field_1352 * h + velocity.field_1350 * i;
        if (k < 0.0) {
            h = -h;
            i = -i;
        }
        double vanillaMaxHorizontalMovementPerTick = 0.4;
        double horizontalMomentumPerTick = this.method_18798().method_37267();
        Supplier<Double> calculateMaxHorizontalMovementPerTick = () -> {
            boolean hasEligibleShape;
            double fallback = this.method_7504();
            if (!this.method_5782()) {
                return fallback;
            }
            if (horizontalMomentumPerTick < vanillaMaxHorizontalMovementPerTick) {
                return fallback;
            }
            if (!AbstractMinecartEntityMixin.isEligibleFastRail(state)) {
                return fallback;
            }
            for (class_2382 directlyAdjDiff : List.of((class_2382)adjacentRailPositions.getFirst(), (class_2382)adjacentRailPositions.getSecond())) {
                class_2338 directlyAdjPos = pos.method_10081(directlyAdjDiff);
                class_2680 directlyAdjState = this.method_37908().method_8320(directlyAdjPos);
                if (AbstractMinecartEntityMixin.isEligibleFastRail(directlyAdjState)) continue;
                return fallback;
            }
            double fallbackSpeedFactor = 1.15;
            fallback *= 1.15;
            boolean bl = hasEligibleShape = railShape == class_2768.field_12665 || railShape == class_2768.field_12674;
            if (!hasEligibleShape) {
                return fallback;
            }
            AtomicInteger eligibleNeighbors = new AtomicInteger();
            HashSet<class_2338> checkedPositions = new HashSet<class_2338>();
            checkedPositions.add(pos);
            BiFunction<class_2338, class_2768, ArrayList> checkNeighbors = (checkPos, checkRailShape) -> {
                Pair<class_2382, class_2382> adjDiffPair = AbstractMinecartEntityMixin.method_22864(checkRailShape);
                ArrayList<Pair> newNeighbors = new ArrayList<Pair>();
                for (class_2382 adjDiff : List.of((class_2382)adjDiffPair.getFirst(), (class_2382)adjDiffPair.getSecond())) {
                    class_2338 nborPos = checkPos.method_10081(adjDiff);
                    if (checkedPositions.contains(nborPos)) continue;
                    class_2680 nborState = this.method_37908().method_8320(nborPos);
                    if (!AbstractMinecartEntityMixin.isEligibleFastRail(nborState)) {
                        return new ArrayList();
                    }
                    class_2768 nborShape = AbstractMinecartEntityMixin.getRailShape(nborState);
                    if (nborShape != railShape) {
                        return new ArrayList();
                    }
                    checkedPositions.add(nborPos);
                    eligibleNeighbors.incrementAndGet();
                    newNeighbors.add(Pair.of((Object)nborPos, (Object)nborShape));
                }
                return newNeighbors;
            };
            ArrayList newNeighbors = checkNeighbors.apply(pos, railShape);
            block1: while (!newNeighbors.isEmpty() && eligibleNeighbors.get() < 16) {
                ArrayList tempNewNeighbors = new ArrayList(newNeighbors);
                newNeighbors.clear();
                for (Pair newNeighbor : tempNewNeighbors) {
                    ArrayList result = checkNeighbors.apply((class_2338)newNeighbor.getFirst(), (class_2768)newNeighbor.getSecond());
                    if (result.isEmpty()) {
                        newNeighbors.clear();
                        continue block1;
                    }
                    newNeighbors.addAll(result);
                }
            }
            int eligibleForwardRailTrackCount = eligibleNeighbors.get() / 2;
            if (eligibleForwardRailTrackCount <= 1) {
                return fallback;
            }
            return (2.01 + (double)eligibleForwardRailTrackCount * 4.0) / 20.0;
        };
        double maxHorizontalMovementPerTick = calculateMaxHorizontalMovementPerTick.get();
        double maxHorizontalMomentumPerTick = Math.max(maxHorizontalMovementPerTick * 5.0, 4.2);
        double l = Math.min(maxHorizontalMomentumPerTick, velocity.method_37267());
        this.method_18799(new class_243(l * h / j, velocity.field_1351, l * i / j));
        class_1297 entity = this.method_31483();
        if (entity instanceof class_1657) {
            class_243 playerVelocity = entity.method_18798();
            double m = playerVelocity.method_37268();
            double n = this.method_18798().method_37268();
            if (m > 1.0E-4 && n < 0.01) {
                this.method_18799(this.method_18798().method_1031(playerVelocity.field_1352 * 0.1, 0.0, playerVelocity.field_1350 * 0.1));
                onBrakeRail = false;
            }
        }
        if (onBrakeRail) {
            double p = this.method_18798().method_37267();
            if (p < 0.03) {
                this.method_18799(class_243.field_1353);
            } else {
                double brakeFactor = 0.5;
                if (horizontalMomentumPerTick > 4.0 * vanillaMaxHorizontalMovementPerTick) {
                    brakeFactor = Math.pow(brakeFactor, 1.0 + (horizontalMomentumPerTick - 3.99 * vanillaMaxHorizontalMovementPerTick) / 1.2);
                }
                this.method_18799(this.method_18798().method_18805(brakeFactor, 0.0, brakeFactor));
            }
        }
        double p = (double)pos.method_10263() + 0.5 + (double)adjacentRail1RelPos.method_10263() * 0.5;
        double q = (double)pos.method_10260() + 0.5 + (double)adjacentRail1RelPos.method_10260() * 0.5;
        double r = (double)pos.method_10263() + 0.5 + (double)adjacentRail2RelPos.method_10263() * 0.5;
        double s = (double)pos.method_10260() + 0.5 + (double)adjacentRail2RelPos.method_10260() * 0.5;
        h = r - p;
        i = s - q;
        if (h == 0.0) {
            x = f - (double)pos.method_10260();
        } else if (i == 0.0) {
            x = d - (double)pos.method_10263();
        } else {
            v = d - p;
            w = f - q;
            x = (v * h + w * i) * 2.0;
        }
        d = p + h * x;
        f = q + i * x;
        this.method_5814(d, e, f);
        v = this.method_5782() ? 0.75 : 1.0;
        w = maxHorizontalMovementPerTick;
        velocity = this.method_18798();
        class_243 movement = new class_243(class_3532.method_15350((double)(v * velocity.field_1352), (double)(-w), (double)w), 0.0, class_3532.method_15350((double)(v * velocity.field_1350), (double)(-w), (double)w));
        this.method_5784(class_1313.field_6308, movement);
        if (adjacentRail1RelPos.method_10264() != 0 && class_3532.method_15357((double)this.method_23317()) - pos.method_10263() == adjacentRail1RelPos.method_10263() && class_3532.method_15357((double)this.method_23321()) - pos.method_10260() == adjacentRail1RelPos.method_10260()) {
            this.method_5814(this.method_23317(), this.method_23318() + (double)adjacentRail1RelPos.method_10264(), this.method_23321());
        } else if (adjacentRail2RelPos.method_10264() != 0 && class_3532.method_15357((double)this.method_23317()) - pos.method_10263() == adjacentRail2RelPos.method_10263() && class_3532.method_15357((double)this.method_23321()) - pos.method_10260() == adjacentRail2RelPos.method_10260()) {
            this.method_5814(this.method_23317(), this.method_23318() + (double)adjacentRail2RelPos.method_10264(), this.method_23321());
        }
        this.method_7525();
        class_243 vec3d4 = this.method_7508(this.method_23317(), this.method_23318(), this.method_23321());
        if (vec3d4 != null && vec3d != null) {
            double aa = (vec3d.field_1351 - vec3d4.field_1351) * 0.05;
            vec3d7 = this.method_18798();
            af = vec3d7.method_37267();
            if (af > 0.0) {
                this.method_18799(vec3d7.method_18805((af + aa) / af, 1.0, (af + aa) / af));
            }
            this.method_5814(this.method_23317(), vec3d4.field_1351, this.method_23321());
        }
        int ac = class_3532.method_15357((double)this.method_23317());
        int ad = class_3532.method_15357((double)this.method_23321());
        if (ac != pos.method_10263() || ad != pos.method_10260()) {
            vec3d7 = this.method_18798();
            af = vec3d7.method_37267();
            this.method_18800(af * class_3532.method_15350((double)(ac - pos.method_10263()), (double)-1.0, (double)1.0), vec3d7.field_1351, af * class_3532.method_15350((double)(ad - pos.method_10260()), (double)-1.0, (double)1.0));
        }
        if (onPoweredRail) {
            vec3d7 = this.method_18798();
            double momentum = vec3d7.method_37267();
            double basisAccelerationPerTick = 0.021;
            if (momentum > 0.01) {
                if (this.method_5782()) {
                    double basisTicksPerSecond = 10.0;
                    double tickMovementForBasisTps = 0.1;
                    double maxSkippedBlocksToConsider = 3.0;
                    double acceleration = 0.021;
                    double distanceMovedHorizontally = movement.method_37267();
                    if (distanceMovedHorizontally > 0.1) {
                        acceleration *= Math.min(40.0, distanceMovedHorizontally / 0.1);
                        double highspeedFactor = 1.0 + class_3532.method_15350((double)(-0.45 * (distanceMovedHorizontally / 0.1 / 10.0)), (double)-0.7, (double)2.0);
                        acceleration *= highspeedFactor;
                    }
                    this.method_18799(vec3d7.method_1031(acceleration * (vec3d7.field_1352 / momentum), 0.0, acceleration * (vec3d7.field_1350 / momentum)));
                } else {
                    this.method_18799(vec3d7.method_1031(vec3d7.field_1352 / momentum * 0.06, 0.0, vec3d7.field_1350 / momentum * 0.06));
                }
            } else {
                class_243 vec3d8 = this.method_18798();
                double ah = vec3d8.field_1352;
                double ai = vec3d8.field_1350;
                double railStopperAcceleration = 0.336;
                if (railShape == class_2768.field_12674) {
                    if (this.method_18803(pos.method_10067())) {
                        ah = 0.336;
                    } else if (this.method_18803(pos.method_10078())) {
                        ah = -0.336;
                    }
                } else {
                    if (railShape != class_2768.field_12665) {
                        return;
                    }
                    if (this.method_18803(pos.method_10095())) {
                        ai = 0.336;
                    } else if (this.method_18803(pos.method_10072())) {
                        ai = -0.336;
                    }
                }
                this.method_18800(ah, vec3d8.field_1351, ai);
            }
        }
    }
}

