/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util.item.filling;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.core.util.item.ItemStackUtil;
import com.minecraftabnormals.abnormals_core.core.util.item.filling.IItemGroupFiller;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;

public final class TargetedItemGroupFiller
implements IItemGroupFiller {
    private final Supplier<Item> targetItem;
    private final Map<ItemGroup, OffsetValue> offsetMap = Maps.newHashMap();

    public TargetedItemGroupFiller(Supplier<Item> targetItem) {
        this.targetItem = targetItem;
    }

    @Override
    public void fillItem(Item item, ItemGroup group, NonNullList<ItemStack> items) {
        if (ItemStackUtil.isInGroup(item, group)) {
            int index;
            OffsetValue offset = this.offsetMap.computeIfAbsent(group, key -> new OffsetValue());
            if (offset.itemsProcessed.contains(item)) {
                offset.reset();
            }
            if ((index = ItemStackUtil.findIndexOfItem(this.targetItem.get(), items)) != -1) {
                items.add(index + offset.offset, (Object)new ItemStack((IItemProvider)item));
                offset.itemsProcessed.add(item);
                offset.offset++;
            } else {
                items.add((Object)new ItemStack((IItemProvider)item));
            }
        }
    }

    static class OffsetValue {
        private final Set<Item> itemsProcessed = Sets.newHashSet();
        private int offset = 1;

        OffsetValue() {
        }

        private void reset() {
            this.offset = 1;
            this.itemsProcessed.clear();
        }
    }
}

