/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util.item;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemStackBuilder {
    private final ItemStack stack;
    private final CompoundNBT tag;

    public ItemStackBuilder(ItemStack stack) {
        this.stack = stack;
        this.tag = stack.func_196082_o();
    }

    public ItemStackBuilder(IItemProvider item) {
        this(new ItemStack(item));
    }

    public ItemStackBuilder setCount(int count) {
        this.stack.func_190920_e(count);
        return this;
    }

    public ItemStackBuilder grow(int amount) {
        this.stack.func_190917_f(amount);
        return this;
    }

    public ItemStackBuilder shrink(int amount) {
        this.stack.func_190918_g(amount);
        return this;
    }

    public ItemStackBuilder setUnbreakable() {
        this.tag.func_74757_a("Unbreakable", true);
        return this;
    }

    public ItemStackBuilder addEnchantment(Enchantment enchantment, int level) {
        this.stack.func_77966_a(enchantment, level);
        return this;
    }

    public ItemStackBuilder setName(@Nullable ITextComponent text) {
        this.stack.func_200302_a(text);
        return this;
    }

    public ItemStackBuilder addLore(ITextComponent text) {
        ListNBT loreListTag;
        CompoundNBT display = this.stack.func_190925_c("display");
        if (display.func_150297_b("Lore", 9)) {
            loreListTag = display.func_150295_c("Lore", 8);
        } else {
            loreListTag = new ListNBT();
            display.func_218657_a("Lore", (INBT)loreListTag);
        }
        loreListTag.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)text)));
        return this;
    }

    public ItemStackBuilder addAttributeModifier(Attribute attribute, AttributeModifier modifier, @Nullable EquipmentSlotType slot) {
        this.stack.func_185129_a(attribute, modifier, slot);
        return this;
    }

    public ItemStackBuilder addAttributeModifier(Attribute attribute, AttributeModifier modifier, EquipmentSlotType ... slots) {
        for (EquipmentSlotType slot : slots) {
            this.stack.func_185129_a(attribute, modifier, slot);
        }
        return this;
    }

    public ItemStackBuilder addPredicate(String key, String predicate) {
        ListNBT predicateList;
        if (this.tag.func_150297_b(key, 9)) {
            predicateList = this.tag.func_150295_c(key, 8);
        } else {
            predicateList = new ListNBT();
            this.tag.func_218657_a(key, (INBT)predicateList);
        }
        predicateList.add((Object)StringNBT.func_229705_a_((String)predicate));
        return this;
    }

    public ItemStackBuilder addCanDestroy(Block block) {
        return this.addPredicate("CanDestroy", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString());
    }

    public ItemStackBuilder addCanPlaceOn(Block block) {
        return this.addPredicate("CanPlaceOn", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString());
    }

    public ItemStack build() {
        return this.stack.func_77946_l();
    }
}

