/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.endimator.instructions;

import com.minecraftabnormals.abnormals_core.core.endimator.entity.EndimatorEntityModel;
import com.minecraftabnormals.abnormals_core.core.endimator.instructions.ModelRendererInstruction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public final class RotateInstruction
extends ModelRendererInstruction<RotateInstruction> {
    private static final Codec<RotateInstruction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("model_renderer").forGetter(instruction -> instruction.modelRenderer), (App)Codec.FLOAT.fieldOf("x").forGetter(instruction -> Float.valueOf(instruction.x)), (App)Codec.FLOAT.fieldOf("y").forGetter(instruction -> Float.valueOf(instruction.y)), (App)Codec.FLOAT.fieldOf("z").forGetter(instruction -> Float.valueOf(instruction.z)), (App)Codec.BOOL.optionalFieldOf("additive", (Object)false).forGetter(instruction -> instruction.additive)).apply((Applicative)instance, RotateInstruction::new));

    public RotateInstruction() {
        super(CODEC);
    }

    private RotateInstruction(String modelRender, float x, float y, float z, boolean additive) {
        super(CODEC, modelRender, x, y, z, additive);
    }

    @Override
    public void process(EndimatorEntityModel<?> model) {
        this.cacheModelRenderer(model);
        if (this.additive) {
            model.rotateAdditive(this.cachedModelRenderer, this.x, this.y, this.z);
        } else {
            model.rotate(this.cachedModelRenderer, this.x, this.y, this.z);
        }
    }
}

