/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.blocks;

import com.blakebr0.cucumber.iface.IModelHelper;
import com.blakebr0.mysticalagriculture.blocks.BlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;

public class BlockStorage
extends BlockBase
implements IModelHelper {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"variant", Type.class);

    public BlockStorage() {
        super("storage", Material.field_151576_e, SoundType.field_185851_d, 4.0f, 6.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.INFERIUM)));
    }

    @Override
    public void init() {
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> stacks) {
        for (Type type : Type.values()) {
            stacks.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public void initModels() {
        for (Type type : Type.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("mysticalagriculture:" + this.func_149739_a().substring(8) + "_" + Type.byMetadata(type.getMetadata()).func_176610_l()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public static enum Type implements IStringSerializable
    {
        INFERIUM(0, "inferium"),
        PRUDENTIUM(1, "prudentium"),
        INTERMEDIUM(2, "intermedium"),
        SUPERIUM(3, "superium"),
        SUPREMIUM(4, "supremium"),
        PROSPERITY(5, "prosperity");

        private static final Type[] META_LOOKUP;
        private final int meta;
        private final String name;

        private Type(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static Type byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.META_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

