/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.network;

import com.rwtema.funkylocomotion.network.MessageClearTile;
import com.rwtema.funkylocomotion.network.MessageObstruction;
import com.rwtema.funkylocomotion.network.MessageOneTimeChat;
import java.util.WeakHashMap;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class FLNetwork {
    private static final WeakHashMap<World, PlayerChunkMap> cache = new WeakHashMap();
    public static SimpleNetworkWrapper net;

    public static void init() {
        net = new SimpleNetworkWrapper("FLoco");
        net.registerMessage(MessageClearTile.Handler.class, MessageClearTile.class, 0, Side.SERVER);
        net.registerMessage(MessageClearTile.Handler.class, MessageClearTile.class, 0, Side.CLIENT);
        net.registerMessage(MessageObstruction.Handler.class, MessageObstruction.class, 1, Side.SERVER);
        net.registerMessage(MessageObstruction.Handler.class, MessageObstruction.class, 1, Side.CLIENT);
        net.registerMessage(MessageOneTimeChat.Handler.class, MessageOneTimeChat.class, 2, Side.SERVER);
        net.registerMessage(MessageOneTimeChat.Handler.class, MessageOneTimeChat.class, 2, Side.CLIENT);
    }

    public static void sendToAllWatchingChunk(World world, BlockPos pos, IMessage message) {
        PlayerChunkMapEntry watcher = FLNetwork.getChunkWatcher(world, pos);
        if (watcher != null) {
            watcher.func_187267_a(net.getPacketFrom(message));
        }
    }

    private static PlayerChunkMap getPlayerManager(World world) {
        if (!cache.containsKey(world)) {
            if (!(world instanceof WorldServer)) {
                cache.put(world, null);
            } else {
                cache.put(world, ((WorldServer)world).func_184164_w());
            }
        }
        return cache.get(world);
    }

    public static void updateChunk(Chunk chunk) {
        World world = chunk.func_177412_p();
        PlayerChunkMapEntry watcher = FLNetwork.getChunkWatcher(chunk, world);
        if (watcher != null) {
            watcher.func_187280_d();
        }
    }

    public static PlayerChunkMapEntry getChunkWatcher(Chunk chunk) {
        return FLNetwork.getChunkWatcher(chunk, chunk.func_177412_p());
    }

    public static PlayerChunkMapEntry getChunkWatcher(Chunk chunk, World world) {
        PlayerChunkMap playerManager = FLNetwork.getPlayerManager(world);
        return playerManager != null ? playerManager.func_187301_b(chunk.field_76635_g, chunk.field_76647_h) : null;
    }

    public static PlayerChunkMapEntry getChunkWatcher(World world, BlockPos pos) {
        return FLNetwork.getChunkWatcher(world, pos.func_177958_n(), pos.func_177952_p());
    }

    public static PlayerChunkMapEntry getChunkWatcher(World world, int x, int z) {
        PlayerChunkMap playerManager = FLNetwork.getPlayerManager(world);
        return playerManager != null ? playerManager.func_187301_b(x >> 4, z >> 4) : null;
    }
}

