/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.blocks.TilePusher;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileSlider
extends TilePusher {
    private static final int[][] orthog = new int[][]{{6, 6, 5, 4, 3, 2, 6}, {6, 6, 4, 5, 2, 3, 6}, {5, 4, 6, 6, 1, 0, 6}, {4, 5, 6, 6, 0, 1, 6}, {3, 2, 1, 0, 6, 6, 6}, {2, 3, 0, 1, 6, 6, 6}, {6, 6, 6, 6, 6, 6, 6}};
    private EnumFacing slideDir = null;

    public static EnumFacing getOrthogonal(EnumFacing a, EnumFacing b) {
        int i = orthog[a.ordinal()][b.ordinal()];
        return i == 6 ? null : EnumFacing.values()[i];
    }

    public void rotateAboutAxis() {
        EnumFacing dir = this.getFacing();
        EnumFacing slide = this.getSlideDir();
        this.slideDir = slide.func_176732_a(dir.func_176740_k());
    }

    public EnumFacing getSlideDir() {
        EnumFacing ang = this.getFacing();
        if (this.slideDir == null || TileSlider.getOrthogonal(ang, this.slideDir) == null) {
            int j = 0;
            while (j >= 6 || TileSlider.getOrthogonal(EnumFacing.values()[j], ang) == null) {
                j = (j + 1) % 6;
            }
            this.slideDir = EnumFacing.values()[j];
        }
        return this.slideDir;
    }

    public void setSlideDir(EnumFacing dir) {
        this.slideDir = dir;
    }

    public EnumFacing getFacing() {
        return EnumFacing.values()[this.func_145832_p() % 6];
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.slideDir = EnumFacing.values()[tag.func_74771_c("SlideDirection")];
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("SlideDirection", (byte)this.slideDir.ordinal());
        return tag;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74774_a("dir", (byte)this.getSlideDir().ordinal());
        return tag;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.slideDir = EnumFacing.values()[tag.func_74771_c("dir")];
        this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @Override
    public EnumFacing getDirection() {
        return this.getSlideDir();
    }

    @Override
    public List<BlockPos> getBlocks(World world, BlockPos home, EnumFacing dir, boolean push) {
        EnumFacing slide = this.getSlideDir();
        BlockPos advance = home.func_177972_a(dir);
        if (BlockHelper.canStick(world, advance, dir.func_176734_d(), this.profile)) {
            return this.getBlocks(world, home, advance, slide);
        }
        return null;
    }
}

