/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.stimulator;

import binnie.core.machines.Machine;
import binnie.core.machines.network.INetwork;
import binnie.extrabees.circuit.StimulatorCircuit;
import binnie.extrabees.utils.ComponentBeeModifier;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class ComponentStimulatorModifier
extends ComponentBeeModifier
implements INetwork.TilePacketSync,
IBeeModifier,
IBeeListener {
    private float powerUsage = 0.0f;
    private boolean powered = false;
    private StimulatorCircuit[] modifiers = new StimulatorCircuit[0];

    public ComponentStimulatorModifier(Machine machine) {
        super(machine);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        Object[] oldModifiers = this.modifiers;
        this.modifiers = this.getCircuits();
        this.powerUsage = 0.0f;
        for (StimulatorCircuit beeMod : this.modifiers) {
            this.powerUsage += (float)beeMod.getPowerUsage();
        }
        boolean oldPowered = this.powered;
        this.powered = this.getUtil().hasEnergyMJ(this.powerUsage);
        if (this.powered != oldPowered || oldModifiers.length != this.modifiers.length || !Arrays.equals(oldModifiers, this.modifiers)) {
            this.getUtil().refreshBlock();
        }
    }

    @Nullable
    private ICircuitBoard getCircuit() {
        if (!this.getUtil().isSlotEmpty(0)) {
            return ChipsetManager.circuitRegistry.getCircuitBoard(this.getUtil().getStack(0));
        }
        return null;
    }

    private StimulatorCircuit[] getCircuits() {
        ICircuitBoard board = this.getCircuit();
        if (board == null) {
            return new StimulatorCircuit[0];
        }
        ICircuit[] circuits = board.getCircuits();
        ArrayList<StimulatorCircuit> mod = new ArrayList<StimulatorCircuit>();
        for (ICircuit circuit : circuits) {
            if (!(circuit instanceof StimulatorCircuit)) continue;
            mod.add((StimulatorCircuit)circuit);
        }
        return mod.toArray(new StimulatorCircuit[0]);
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getTerritoryModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getMutationModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, @Nullable IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getLifespanModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getProductionModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getFloweringModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getGeneticDecay(genome, mod);
        }
        return mod;
    }

    @Override
    public boolean isSealed() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isSealed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isSelfLighted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isSunlightSimulated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHellish() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isHellish()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void wearOutEquipment(int amount) {
        this.getUtil().useEnergyMJ(this.powerUsage);
    }

    @Override
    public void syncToNBT(NBTTagCompound nbt) {
        NBTTagList circuitsTag = new NBTTagList();
        for (StimulatorCircuit modifier : this.modifiers) {
            circuitsTag.func_74742_a((NBTBase)new NBTTagString(modifier.getUID()));
        }
        nbt.func_74782_a("modifiers", (NBTBase)circuitsTag);
        nbt.func_74757_a("powered", this.powered);
    }

    @Override
    public void syncFromNBT(NBTTagCompound nbt) {
        NBTTagList circuitsTag = nbt.func_150295_c("modifiers", 8);
        LinkedList<StimulatorCircuit> circuits = new LinkedList<StimulatorCircuit>();
        for (int i = 0; i < circuitsTag.func_74745_c(); ++i) {
            ICircuit circuit = ChipsetManager.circuitRegistry.getCircuit(circuitsTag.func_150307_f(i));
            if (!(circuit instanceof StimulatorCircuit)) continue;
            circuits.add((StimulatorCircuit)circuit);
        }
        this.modifiers = circuits.toArray(new StimulatorCircuit[0]);
        this.powered = nbt.func_74767_n("powered");
    }
}

