/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.util;

import binnie.core.ModId;
import binnie.core.proxy.I18NProxy;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class I18N {
    @Nullable
    private static NumberFormat percentFormat;
    @Nullable
    private static NumberFormat numberFormat;
    @SidedProxy(clientSide="binnie.core.proxy.I18NClient", serverSide="binnie.core.proxy.I18NServer", modId="binniecore")
    private static I18NProxy proxy;

    public static void onResourceReload() {
        percentFormat = null;
        numberFormat = null;
    }

    public static NumberFormat getPercentFormat() {
        if (percentFormat == null) {
            percentFormat = DecimalFormat.getPercentInstance(I18N.getLocale());
        }
        return percentFormat;
    }

    public static NumberFormat getNumberFormat() {
        if (numberFormat == null) {
            numberFormat = DecimalFormat.getNumberInstance(I18N.getLocale());
        }
        return numberFormat;
    }

    public static String localiseOrBlank(String key) {
        return proxy.localiseOrBlank(key);
    }

    public static String localise(String key) {
        return proxy.localise(key);
    }

    public static String localise(ModId modId, String path, Object ... format) {
        return proxy.localise(modId, path, format);
    }

    public static String localise(ResourceLocation key) {
        return proxy.localise(key);
    }

    public static boolean canLocalise(String key) {
        return proxy.canLocalise(key);
    }

    public static String localise(String key, Object ... format) {
        return proxy.localise(key, format);
    }

    public static String localise(ResourceLocation key, Object ... format) {
        return proxy.localise(key, format);
    }

    @SideOnly(value=Side.CLIENT)
    public static Locale getLocale() {
        Language currentLanguage;
        LanguageManager languageManager;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft != null && (languageManager = minecraft.func_135016_M()) != null && (currentLanguage = languageManager.func_135041_c()) != null) {
            return currentLanguage.getJavaLocale();
        }
        return Locale.getDefault();
    }
}

