/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.SortingUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;

public class SortWarehouseMessage
extends AbstractMessage<SortWarehouseMessage, IMessage> {
    private static final int REQUIRED_LEVEL_TO_SORT_WAREHOUSE = 3;
    private BlockPos buildingId;
    private int colonyId;
    private int dimension;

    public SortWarehouseMessage() {
    }

    public SortWarehouseMessage(@NotNull AbstractBuildingView building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(SortWarehouseMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony == null) {
            Log.getLogger().warn("UpgradeWarehouseMessage colony is null");
            return;
        }
        if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
            return;
        }
        IBuilding building = colony.getBuildingManager().getBuilding(message.buildingId);
        if (!(building instanceof BuildingWareHouse)) {
            Log.getLogger().warn("UpgradeWarehouseMessage building is not a Warehouse");
            return;
        }
        if (building.getBuildingLevel() >= 3) {
            CombinedItemHandler inv = (CombinedItemHandler)building.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            SortingUtils.sort(inv);
        }
    }
}

