/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class HutRenameMessage
extends AbstractMessage<HutRenameMessage, IMessage> {
    private int colonyId;
    private String name;
    private BlockPos buildingId;
    private int dimension;

    public HutRenameMessage() {
    }

    public HutRenameMessage(@NotNull IColony colony, String name, AbstractBuildingView b) {
        this.colonyId = colony.getID();
        this.name = name;
        this.dimension = colony.getDimension();
        this.buildingId = b.getID();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.dimension = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeInt(this.dimension);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
    }

    @Override
    public void messageOnServerThread(HutRenameMessage message, EntityPlayerMP player) {
        IBuilding b;
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null && colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS) && (b = colony.getBuildingManager().getBuildings().get(message.buildingId)) != null) {
            b.setCustomBuildingName(message.name);
        }
    }
}

