/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class HireFireMessage
extends AbstractMessage<HireFireMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private boolean hire;
    private int citizenID;
    private int dimension;

    public HireFireMessage() {
    }

    public HireFireMessage(@NotNull AbstractBuildingView building, boolean hire, int citizenID) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.hire = hire;
        this.citizenID = citizenID;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.hire = buf.readBoolean();
        this.citizenID = buf.readInt();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeBoolean(this.hire);
        buf.writeInt(this.citizenID);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(HireFireMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            ICitizenData citizen = colony.getCitizenManager().getCitizen(message.citizenID);
            citizen.setPaused(false);
            if (message.hire) {
                colony.getBuildingManager().getBuilding(message.buildingId).assignCitizen(citizen);
            } else {
                colony.getBuildingManager().getBuilding(message.buildingId).removeCitizen(citizen);
            }
        }
    }
}

