/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingEnchanter;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class EnchanterWorkerSetMessage
extends AbstractMessage<EnchanterWorkerSetMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private int dimension;
    private BlockPos worker;
    private boolean add;

    public EnchanterWorkerSetMessage() {
    }

    public EnchanterWorkerSetMessage(@NotNull BuildingEnchanter.View building, BlockPos worker, boolean add) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.worker = worker;
        this.dimension = building.getColony().getDimension();
        this.add = add;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.dimension = buf.readInt();
        this.worker = BlockPosUtil.readFromByteBuf(buf);
        this.add = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.dimension);
        BlockPosUtil.writeToByteBuf(buf, this.worker);
        buf.writeBoolean(this.add);
    }

    @Override
    public void messageOnServerThread(EnchanterWorkerSetMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            BuildingEnchanter building = colony.getBuildingManager().getBuilding(message.buildingId, BuildingEnchanter.class);
            if (building != null) {
                if (message.add) {
                    building.addWorker(message.worker);
                } else {
                    building.removeWorker(message.worker);
                }
            }
        }
    }
}

