/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class BuyCitizenMessage
extends AbstractMessage<BuyCitizenMessage, IMessage> {
    private int colonyId;
    private int buyItemIndex;
    private int dimension;

    public BuyCitizenMessage() {
    }

    public BuyCitizenMessage(@NotNull BuyCitizenType buyCitizenType, @NotNull int colonyId, @NotNull int dimension) {
        this.buyItemIndex = buyCitizenType.getIndex();
        this.colonyId = colonyId;
        this.dimension = dimension;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.dimension = buf.readInt();
        this.buyItemIndex = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.dimension);
        buf.writeInt(this.buyItemIndex);
    }

    @Override
    public void messageOnServerThread(BuyCitizenMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony == null || !colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
            return;
        }
        if (colony.getCitizenManager().getCurrentCitizenCount() < colony.getCitizenManager().getPotentialMaxCitizens()) {
            BuyCitizenType buyCitizenType = BuyCitizenType.getFromIndex(message.buyItemIndex);
            ItemStack toRemove = new ItemStack(buyCitizenType.item, 1);
            toRemove.func_190920_e(colony.getBoughtCitizenCost() + 1);
            InvWrapper playerInv = new InvWrapper((IInventory)player.field_71071_by);
            if (InventoryUtils.removeStackFromItemHandler((IItemHandler)playerInv, toRemove)) {
                colony.increaseBoughtCitizenCost();
                ICitizenData data = colony.getCitizenManager().createAndRegisterNewCitizenData();
                double maxStat = colony.getOverallHappiness() - 1.0;
                double high = maxStat * (double)buyCitizenType.index / 4.0;
                double low = maxStat * (double)(buyCitizenType.index - 1) / 4.0;
                Random rand = new Random();
                data.setIntelligence((int)Math.round(rand.nextDouble() * (high - low) + low));
                data.setEndurance((int)Math.round(rand.nextDouble() * (high - low) + low));
                data.setDexterity((int)Math.round(rand.nextDouble() * (high - low) + low));
                data.setCharisma((int)Math.round(rand.nextDouble() * (high - low) + low));
                data.setStrength((int)Math.round(rand.nextDouble() * (high - low) + low));
                LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "com.minecolonies.coremod.progress.hireCitizen", new Object[0]);
                colony.getCitizenManager().spawnOrCreateCitizen(data, colony.getWorld(), null, true);
            }
        }
    }

    public static enum BuyCitizenType {
        HAY_BALE(1, Item.func_150898_a((Block)Blocks.field_150407_cf)),
        BOOK(2, Items.field_151122_aG),
        EMERALD(3, Items.field_151166_bC),
        DIAMOND(4, Items.field_151045_i);

        private final int index;
        private final Item item;

        private BuyCitizenType(int index, Item item) {
            this.index = index;
            this.item = item;
        }

        public int getIndex() {
            return this.index;
        }

        public Item getItem() {
            return this.item;
        }

        public static BuyCitizenType getFromIndex(int index) {
            for (BuyCitizenType type : BuyCitizenType.values()) {
                if (type.index != index) continue;
                return type;
            }
            return DIAMOND;
        }
    }
}

