/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.api.blocks.AbstractBlockBarrel;
import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.PathPointExtended;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPathJob
implements Callable<Path> {
    protected static final int DEBUG_VERBOSITY_NONE = 0;
    protected static final int DEBUG_VERBOSITY_BASIC = 1;
    protected static final int DEBUG_VERBOSITY_FULL = 2;
    protected static final Object debugNodeMonitor = new Object();
    private static final int SHIFT_SOUTH = 1;
    private static final int SHIFT_WEST = 2;
    private static final int SHIFT_NORTH = 3;
    private static final int SHIFT_EAST = 4;
    private static final BlockPos BLOCKPOS_IDENTITY = new BlockPos(0, 0, 0);
    private static final BlockPos BLOCKPOS_UP = new BlockPos(0, 1, 0);
    private static final BlockPos BLOCKPOS_DOWN = new BlockPos(0, -1, 0);
    private static final BlockPos BLOCKPOS_NORTH = new BlockPos(0, 0, -1);
    private static final BlockPos BLOCKPOS_SOUTH = new BlockPos(0, 0, 1);
    private static final BlockPos BLOCKPOS_EAST = new BlockPos(1, 0, 0);
    private static final BlockPos BLOCKPOS_WEST = new BlockPos(-1, 0, 0);
    private static final int MAX_Y = 256;
    private static final int MIN_Y = 0;
    private static final int MAX_NODES_VISITED = Configurations.pathfinding.pathfindingMaxNodes;
    private static final double JUMP_DROP_COST = 2.5;
    private static final double ON_PATH_COST = 0.5;
    private static final double SWIM_COST = 10.0;
    private static final double TOO_CLOSE_TO_FENCE = 0.1;
    private static final double TOO_FAR_FROM_FENCE = 0.9;
    private static final int SHIFT_X_BY = 20;
    private static final int SHIFT_Y_BY = 12;
    @Nullable
    protected static Set<Node> lastDebugNodesVisited;
    @Nullable
    protected static Set<Node> lastDebugNodesNotVisited;
    @Nullable
    protected static Set<Node> lastDebugNodesPath;
    @NotNull
    protected final BlockPos start;
    @NotNull
    protected final IBlockAccess world;
    protected final PathResult result;
    private final int maxRange;
    private final Queue<Node> nodesOpen = new PriorityQueue<Node>(500);
    private final Map<Integer, Node> nodesVisited = new HashMap<Integer, Node>();
    protected boolean debugDrawEnabled = false;
    @Nullable
    protected Set<Node> debugNodesVisited = null;
    @Nullable
    protected Set<Node> debugNodesNotVisited = null;
    @Nullable
    protected Set<Node> debugNodesPath = null;
    private boolean allowSwimming = true;
    private boolean allowJumpPointSearchTypeWalk = false;
    private int totalNodesAdded = 0;
    private int totalNodesVisited = 0;
    private boolean xzRestricted = false;
    private int maxX;
    private int minX;
    private int maxZ;
    private int minZ;
    private WeakReference<EntityLivingBase> entity;

    public AbstractPathJob(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range, EntityLivingBase entity) {
        this(world, start, end, range, new PathResult(), entity);
    }

    public AbstractPathJob(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range, PathResult result, EntityLivingBase entity) {
        int minX = Math.min(start.func_177958_n(), end.func_177958_n()) - range / 2;
        int minZ = Math.min(start.func_177952_p(), end.func_177952_p()) - range / 2;
        int maxX = Math.max(start.func_177958_n(), end.func_177958_n()) + range / 2;
        int maxZ = Math.max(start.func_177952_p(), end.func_177952_p()) + range / 2;
        this.world = new ChunkCache(world, new BlockPos(minX, 0, minZ), new BlockPos(maxX, 256, maxZ), range);
        this.start = new BlockPos((Vec3i)start);
        this.maxRange = range;
        this.result = result;
        this.allowJumpPointSearchTypeWalk = false;
        if (Configurations.pathfinding.pathfindingDebugDraw) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<Node>();
            this.debugNodesNotVisited = new HashSet<Node>();
            this.debugNodesPath = new HashSet<Node>();
        }
        this.entity = new WeakReference<EntityLivingBase>(entity);
    }

    public AbstractPathJob(World world, BlockPos startRestriction, BlockPos endRestriction, PathResult result, EntityLivingBase entity) {
        this.minX = Math.min(startRestriction.func_177958_n(), endRestriction.func_177958_n());
        this.minZ = Math.min(startRestriction.func_177952_p(), endRestriction.func_177952_p());
        this.maxX = Math.max(startRestriction.func_177958_n(), endRestriction.func_177958_n());
        this.maxZ = Math.max(startRestriction.func_177952_p(), endRestriction.func_177952_p());
        this.xzRestricted = true;
        int range = (int)Math.sqrt(Math.pow(this.maxX - this.minX, 2.0) + Math.pow(this.maxZ - this.minZ, 2.0)) * 2;
        this.world = new ChunkCache(world, new BlockPos(this.minX, 0, this.minZ), new BlockPos(this.maxX, 256, this.maxZ), range);
        this.start = new BlockPos((this.minX + this.maxX) / 2, (startRestriction.func_177956_o() + endRestriction.func_177956_o()) / 2, (this.minZ + this.maxZ) / 2);
        this.maxRange = range;
        this.result = result;
        this.allowJumpPointSearchTypeWalk = false;
        if (Configurations.pathfinding.pathfindingDebugDraw) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<Node>();
            this.debugNodesNotVisited = new HashSet<Node>();
            this.debugNodesPath = new HashSet<Node>();
        }
        this.entity = new WeakReference<EntityLivingBase>(entity);
    }

    private static boolean onLadderGoingUp(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        return currentNode.isLadder() && (dPos.func_177956_o() >= 0 || dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0);
    }

    public static BlockPos prepareStart(@NotNull EntityLiving entity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), (int)entity.field_70163_u, MathHelper.func_76128_c((double)entity.field_70161_v));
        IBlockState bs = CompatibilityUtils.getWorldFromEntity((Entity)entity).func_180495_p((BlockPos)pos);
        Block b = bs.func_177230_c();
        if (entity.func_70090_H()) {
            while (bs.func_185904_a().func_76224_d()) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                bs = CompatibilityUtils.getWorldFromEntity((Entity)entity).func_180495_p((BlockPos)pos);
            }
        } else if (b instanceof BlockFence || b instanceof BlockWall || b instanceof AbstractBlockMinecoloniesDefault) {
            double dX = entity.field_70165_t - Math.floor(entity.field_70165_t);
            double dZ = entity.field_70161_v - Math.floor(entity.field_70161_v);
            if (dX < 0.1) {
                pos.func_181079_c(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            } else if (dX > 0.9) {
                pos.func_181079_c(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            if (dZ < 0.1) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            } else if (dZ > 0.9) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
        }
        return pos.func_185334_h();
    }

    private static void setLadderFacing(@NotNull IBlockAccess world, BlockPos pos, @NotNull PathPointExtended p) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockVine) {
            int meta = world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
            if ((meta >>> 1 & 1) != 0) {
                p.setLadderFacing(EnumFacing.SOUTH);
            } else if ((meta >>> 2 & 1) != 0) {
                p.setLadderFacing(EnumFacing.WEST);
            } else if ((meta >>> 3 & 1) != 0) {
                p.setLadderFacing(EnumFacing.NORTH);
            } else if ((meta >>> 4 & 1) != 0) {
                p.setLadderFacing(EnumFacing.EAST);
            }
        } else {
            p.setLadderFacing((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockLadder.field_176382_a));
        }
    }

    private static boolean onALadder(@NotNull Node node, @Nullable Node nextInPath, @NotNull BlockPos pos) {
        return nextInPath != null && node.isLadder() && nextInPath.pos.func_177958_n() == pos.func_177958_n() && nextInPath.pos.func_177952_p() == pos.func_177952_p();
    }

    private static int computeNodeKey(@NotNull BlockPos pos) {
        return (pos.func_177958_n() & 0xFFF) << 20 | (pos.func_177956_o() & 0xFF) << 12 | pos.func_177952_p() & 0xFFF;
    }

    protected static double computeCost(@NotNull BlockPos dPos, boolean isSwimming, boolean onPath) {
        double cost = 1.0;
        if (dPos.func_177956_o() != 0 && (dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0)) {
            cost *= 2.5;
        }
        if (onPath) {
            cost *= 0.5;
        }
        if (isSwimming) {
            cost *= 10.0;
        }
        return cost;
    }

    private static boolean checkPreconditions(Node node, int newY) {
        if (AbstractPathJob.nodeClosed(node)) {
            return true;
        }
        return newY < 0;
    }

    private static boolean nodeClosed(@Nullable Node node) {
        return node != null && node.isClosed();
    }

    private static boolean calculateSwimming(@NotNull IBlockAccess world, @NotNull BlockPos pos, @Nullable Node node) {
        return node == null ? world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76224_d() : node.isSwimming();
    }

    public PathResult getResult() {
        return this.result;
    }

    @Override
    public final Path call() {
        try {
            return this.search();
        }
        catch (Exception e) {
            Log.getLogger().warn("Pathfinding Exception", (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Path search() {
        Node bestNode = this.getAndSetupStartNode();
        double bestNodeResultScore = this.getNodeResultScore(bestNode);
        while (!this.nodesOpen.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Node currentNode = this.nodesOpen.poll();
            ++this.totalNodesVisited;
            if (this.totalNodesVisited > MAX_NODES_VISITED) break;
            currentNode.setCounterVisited(this.totalNodesVisited);
            this.handleDebugOptions(currentNode);
            if (this.isAtDestination(currentNode)) {
                bestNode = currentNode;
                this.result.setPathReachesDestination(true);
                break;
            }
            double nodeResultScore = this.getNodeResultScore(currentNode);
            if (nodeResultScore > bestNodeResultScore) {
                bestNode = currentNode;
                bestNodeResultScore = nodeResultScore;
            }
            if (BlockPosUtil.getDistanceSquared2D(currentNode.pos, this.start) > (long)(this.maxRange * this.maxRange) || this.xzRestricted && (currentNode.pos.func_177958_n() < this.minX || currentNode.pos.func_177958_n() > this.maxX || currentNode.pos.func_177952_p() < this.minZ || currentNode.pos.func_177952_p() > this.maxZ)) continue;
            this.walkCurrentNode(currentNode);
        }
        Path path = this.finalizePath(bestNode);
        this.handleDebugDraw();
        return path;
    }

    private void handleDebugOptions(Node currentNode) {
        if (this.debugDrawEnabled) {
            this.addNodeToDebug(currentNode);
        }
        currentNode.setClosed();
        if (Configurations.pathfinding.pathfindingDebugVerbosity == 2) {
            Log.getLogger().info(String.format("Examining node [%d,%d,%d] ; g=%f ; f=%f", currentNode.pos.func_177958_n(), currentNode.pos.func_177956_o(), currentNode.pos.func_177952_p(), currentNode.getCost(), currentNode.getScore()));
        }
    }

    private void addNodeToDebug(Node currentNode) {
        this.debugNodesNotVisited.remove(currentNode);
        this.debugNodesVisited.add(currentNode);
    }

    private void addPathNodeToDebug(Node node) {
        this.debugNodesVisited.remove(node);
        this.debugNodesPath.add(node);
    }

    private void walkCurrentNode(@NotNull Node currentNode) {
        BlockPos dPos = BLOCKPOS_IDENTITY;
        if (currentNode.parent != null) {
            dPos = currentNode.pos.func_177973_b((Vec3i)currentNode.parent.pos);
        }
        if (AbstractPathJob.onLadderGoingUp(currentNode, dPos)) {
            this.walk(currentNode, BLOCKPOS_UP);
        }
        if (this.onLadderGoingDown(currentNode, dPos)) {
            this.walk(currentNode, BLOCKPOS_DOWN);
        }
        if (dPos.func_177952_p() <= 0) {
            this.walk(currentNode, BLOCKPOS_NORTH);
        }
        if (dPos.func_177958_n() >= 0) {
            this.walk(currentNode, BLOCKPOS_EAST);
        }
        if (dPos.func_177952_p() >= 0) {
            this.walk(currentNode, BLOCKPOS_SOUTH);
        }
        if (dPos.func_177958_n() <= 0) {
            this.walk(currentNode, BLOCKPOS_WEST);
        }
    }

    private boolean onLadderGoingDown(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        return (dPos.func_177956_o() <= 0 || dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0) && this.isLadder(currentNode.pos.func_177977_b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDebugDraw() {
        if (this.debugDrawEnabled) {
            Object object = debugNodeMonitor;
            synchronized (object) {
                lastDebugNodesNotVisited = this.debugNodesNotVisited;
                lastDebugNodesVisited = this.debugNodesVisited;
                lastDebugNodesPath = this.debugNodesPath;
            }
        }
    }

    @NotNull
    private Node getAndSetupStartNode() {
        Node startNode = new Node(this.start, this.computeHeuristic(this.start));
        if (this.isLadder(this.start)) {
            startNode.setLadder();
        } else if (this.world.func_180495_p(this.start).func_185904_a().func_76224_d()) {
            startNode.setSwimming();
        }
        this.nodesOpen.offer(startNode);
        this.nodesVisited.put(AbstractPathJob.computeNodeKey(this.start), startNode);
        ++this.totalNodesAdded;
        return startNode;
    }

    @NotNull
    private Path finalizePath(Node targetNode) {
        int pathLength = 0;
        Node node = targetNode;
        while (node.parent != null) {
            ++pathLength;
            node = node.parent;
        }
        PathPoint[] points = new PathPoint[pathLength];
        Node nextInPath = null;
        node = targetNode;
        while (node.parent != null) {
            if (this.debugDrawEnabled) {
                this.addPathNodeToDebug(node);
            }
            --pathLength;
            BlockPos pos = node.pos;
            if (node.isSwimming()) {
                pos.func_177971_a((Vec3i)BLOCKPOS_DOWN);
            }
            PathPointExtended p = new PathPointExtended(pos);
            if (nextInPath != null && AbstractPathJob.onALadder(node, nextInPath, pos)) {
                p.setOnLadder(true);
                if (nextInPath.pos.func_177956_o() > pos.func_177956_o()) {
                    AbstractPathJob.setLadderFacing(this.world, pos, p);
                }
            } else if (AbstractPathJob.onALadder(node.parent, node.parent, pos)) {
                p.setOnLadder(true);
            }
            points[pathLength] = p;
            nextInPath = node;
            node = node.parent;
        }
        this.doDebugPrinting(points);
        return new Path(points);
    }

    private void doDebugPrinting(@NotNull PathPoint[] points) {
        if (Configurations.pathfinding.pathfindingDebugVerbosity > 0) {
            Log.getLogger().info("Path found:");
            for (PathPoint p : points) {
                Log.getLogger().info(String.format("Step: [%d,%d,%d]", p.field_75839_a, p.field_75837_b, p.field_75838_c));
            }
            Log.getLogger().info(String.format("Total Nodes Visited %d / %d", this.totalNodesVisited, this.totalNodesAdded));
        }
    }

    protected abstract double computeHeuristic(BlockPos var1);

    protected abstract boolean isAtDestination(Node var1);

    protected abstract double getNodeResultScore(Node var1);

    protected final boolean walk(@NotNull Node parent, @NotNull BlockPos dPos) {
        int newY;
        BlockPos pos = parent.pos.func_177971_a((Vec3i)dPos);
        int nodeKey = AbstractPathJob.computeNodeKey(pos);
        Node node = this.nodesVisited.get(nodeKey);
        if (AbstractPathJob.checkPreconditions(node, newY = this.getGroundHeight(parent, pos))) {
            return false;
        }
        BlockPos yFix = BlockPos.field_177992_a;
        if (pos.func_177956_o() != newY) {
            yFix = dPos.func_177982_a(0, newY - pos.func_177956_o(), 0);
            nodeKey = AbstractPathJob.computeNodeKey(pos = new BlockPos(pos.func_177958_n(), newY, pos.func_177952_p()));
            node = this.nodesVisited.get(nodeKey);
            if (AbstractPathJob.nodeClosed(node)) {
                return false;
            }
        }
        boolean isSwimming = AbstractPathJob.calculateSwimming(this.world, pos, node);
        boolean onRoad = BlockUtils.isPathBlock(this.world.func_180495_p(pos.func_177977_b()).func_177230_c());
        double stepCost = AbstractPathJob.computeCost(dPos.func_177971_a((Vec3i)yFix), isSwimming, onRoad);
        double heuristic = this.computeHeuristic(pos);
        double cost = parent.getCost() + stepCost;
        double score = cost + heuristic;
        if (node == null) {
            node = this.createNode(parent, pos, nodeKey, isSwimming, heuristic, cost, score);
        } else if (this.updateCurrentNode(parent, node, heuristic, cost, score)) {
            return false;
        }
        this.nodesOpen.offer(node);
        this.performJumpPointSearch(parent, dPos, node);
        return true;
    }

    private void performJumpPointSearch(@NotNull Node parent, @NotNull BlockPos dPos, @NotNull Node node) {
        if (this.allowJumpPointSearchTypeWalk && node.getHeuristic() <= parent.getHeuristic()) {
            this.walk(node, dPos);
        }
    }

    @NotNull
    private Node createNode(Node parent, @NotNull BlockPos pos, int nodeKey, boolean isSwimming, double heuristic, double cost, double score) {
        Node node = new Node(parent, pos, cost, heuristic, score);
        this.nodesVisited.put(nodeKey, node);
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.add(node);
        }
        if (this.isLadder(pos)) {
            node.setLadder();
        } else if (isSwimming) {
            node.setSwimming();
        }
        ++this.totalNodesAdded;
        node.setCounterAdded(this.totalNodesAdded);
        return node;
    }

    private boolean updateCurrentNode(@NotNull Node parent, @NotNull Node node, double heuristic, double cost, double score) {
        if (score >= node.getScore()) {
            return true;
        }
        if (!this.nodesOpen.remove(node)) {
            return true;
        }
        node.parent = parent;
        node.setSteps(parent.getSteps() + 1);
        node.setCost(cost);
        node.setHeuristic(heuristic);
        node.setScore(score);
        return false;
    }

    protected int getGroundHeight(Node parent, @NotNull BlockPos pos) {
        if (this.checkHeadBlock(parent, pos)) {
            return -1;
        }
        IBlockState target = this.world.func_180495_p(pos);
        if (!this.isPassable(target)) {
            return this.handleTargeNotPassable(parent, pos, target);
        }
        IBlockState below = this.world.func_180495_p(pos.func_177977_b());
        SurfaceType walkability = this.isWalkableSurface(below, pos);
        if (walkability == SurfaceType.WALKABLE) {
            return pos.func_177956_o();
        }
        if (walkability == SurfaceType.NOT_PASSABLE) {
            return -1;
        }
        return this.handleNotStanding(parent, pos, below);
    }

    private int handleNotStanding(@Nullable Node parent, @NotNull BlockPos pos, @NotNull IBlockState below) {
        boolean isSwimming;
        boolean bl = isSwimming = parent != null && parent.isSwimming();
        if (below.func_185904_a().func_76224_d()) {
            return this.handleInLiquid(pos, below, isSwimming);
        }
        if (this.isLadder(below.func_177230_c(), pos.func_177977_b())) {
            return pos.func_177956_o();
        }
        return this.checkDrop(parent, pos, isSwimming);
    }

    private int checkDrop(@Nullable Node parent, @NotNull BlockPos pos, boolean isSwimming) {
        boolean canDrop;
        boolean bl = canDrop = parent != null && !parent.isLadder();
        if (!canDrop || isSwimming) {
            return -1;
        }
        for (int i = 2; i <= 4; ++i) {
            IBlockState below = this.world.func_180495_p(pos.func_177979_c(i));
            if (this.isWalkableSurface(below, pos) == SurfaceType.WALKABLE) {
                return pos.func_177956_o() - i + 1;
            }
            if (below.func_185904_a() == Material.field_151579_a) continue;
            return -1;
        }
        return -1;
    }

    private int handleInLiquid(@NotNull BlockPos pos, @NotNull IBlockState below, boolean isSwimming) {
        if (isSwimming) {
            return pos.func_177956_o();
        }
        if (this.allowSwimming && below.func_185904_a() == Material.field_151586_h) {
            return pos.func_177956_o();
        }
        return -1;
    }

    private int handleTargeNotPassable(@Nullable Node parent, @NotNull BlockPos pos, @NotNull IBlockState target) {
        boolean canJump;
        boolean bl = canJump = parent != null && !parent.isLadder() && !parent.isSwimming();
        if (!canJump || this.isWalkableSurface(target, pos) != SurfaceType.WALKABLE) {
            return -1;
        }
        if (!this.isPassable(pos.func_177981_b(2))) {
            return -1;
        }
        if (!this.isPassable(parent.pos.func_177981_b(2))) {
            return -1;
        }
        IBlockState below = this.world.func_180495_p(parent.pos.func_177977_b());
        AxisAlignedBB bb = below.func_185890_d(this.world, pos.func_177977_b());
        if (bb != null && bb.field_72337_e < 1.0) {
            return -1;
        }
        return pos.func_177956_o() + 1;
    }

    private boolean checkHeadBlock(@Nullable Node parent, @NotNull BlockPos pos) {
        BlockPos localPos = pos;
        AxisAlignedBB bb = this.world.func_180495_p(localPos).func_185890_d(this.world, localPos);
        if (bb != null && bb.field_72337_e < 1.0) {
            localPos = pos.func_177984_a();
        }
        if (!this.isPassable(pos.func_177984_a())) {
            return true;
        }
        if (parent != null) {
            IBlockState hereState = this.world.func_180495_p(localPos.func_177977_b());
            return hereState.func_185904_a().func_76224_d() && !this.isPassable(pos);
        }
        return false;
    }

    protected boolean isPassable(@NotNull IBlockState block) {
        if (block.func_185904_a() != Material.field_151579_a) {
            if (block.func_185904_a().func_76230_c()) {
                return block.func_177230_c() instanceof BlockDoor || block.func_177230_c() instanceof BlockFenceGate || block.func_177230_c() instanceof AbstractBlockMinecoloniesConstructionTape || block.func_177230_c() instanceof BlockPressurePlate;
            }
            return !block.func_185904_a().func_76224_d();
        }
        return true;
    }

    protected boolean isPassable(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_177230_c().func_176205_b(this.world, pos)) {
            return true;
        }
        return this.isPassable(state);
    }

    @NotNull
    protected SurfaceType isWalkableSurface(@NotNull IBlockState blockState, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block instanceof BlockFence || block instanceof BlockFenceGate || block instanceof BlockWall || block instanceof AbstractBlockMinecoloniesDefault || block instanceof AbstractBlockBarrel || blockState.func_185890_d(this.world, pos) != null && blockState.func_185890_d((IBlockAccess)this.world, (BlockPos)pos).field_72337_e > 1.0) {
            return SurfaceType.NOT_PASSABLE;
        }
        if (block instanceof AbstractBlockMinecoloniesConstructionTape) {
            return SurfaceType.DROPABLE;
        }
        if (blockState.func_185904_a().func_76220_a()) {
            return SurfaceType.WALKABLE;
        }
        return SurfaceType.DROPABLE;
    }

    protected boolean isLadder(@NotNull Block block, BlockPos pos) {
        return block.isLadder(this.world.func_180495_p(pos), this.world, pos, (EntityLivingBase)this.entity.get());
    }

    protected boolean isLadder(BlockPos pos) {
        return this.isLadder(this.world.func_180495_p(pos).func_177230_c(), pos);
    }

    protected boolean isAllowedSwimming() {
        return this.allowSwimming;
    }

    protected void setAllowedSwimming(boolean allowSwimming) {
        this.allowSwimming = allowSwimming;
    }

    private static enum SurfaceType {
        WALKABLE,
        DROPABLE,
        NOT_PASSABLE;

    }
}

