/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteractionResponseHandler;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIStructureMiner
extends AbstractEntityAIStructureWithWorkOrder<JobMiner> {
    private static final String MAIN_SHAFT_NAME = "/miner/minerMainShaft";
    private static final String X4_SHAFT_NAME = "/miner/minerX4";
    private static final String X2_RIGHT_SHAFT_NAME = "/miner/minerX2Right";
    private static final String X2_TOP_SHAFT_NAME = "/miner/minerX2Top";
    private static final int OTHER_SIDE_OF_SHAFT = 6;
    private static final int COBBLE_REQUEST_BATCHES = 32;
    private static final int LADDER_REQUEST_BATCHES = 10;
    private static final String RENDER_META_TORCH = "Torch";
    private static final int NODE_DISTANCE = 7;
    private static final int MAX_BLOCKS_MINED = 64;
    private static final int LADDER_SEARCH_RANGE = 10;
    private static final int SHAFT_RADIUS = 3;
    private static final int SAFE_CHECK_RANGE = 5;
    private static final int ROTATE_ONCE = 1;
    private static final int ROTATE_TWICE = 2;
    private static final int ROTATE_THREE_TIMES = 3;
    private static final int ROTATE_FOUR_TIMES = 4;
    private static final int LIQUID_CHECK_RANGE = 5;
    @Nullable
    private BlockPos minerWorkingLocation;
    @Nullable
    private BlockPos currentStandingPosition;
    @Nullable
    private Node workingNode = null;

    public EntityAIStructureMiner(@NotNull JobMiner job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForMining, 1), new AITarget((IAIState)AIWorkerState.MINER_SEARCHING_LADDER, this::lookForLadder, 20), new AITarget((IAIState)AIWorkerState.MINER_WALKING_TO_LADDER, this::goToLadder, 20), new AITarget((IAIState)AIWorkerState.MINER_CHECK_MINESHAFT, this::checkMineShaft, 20), new AITarget((IAIState)AIWorkerState.MINER_MINING_SHAFT, this::doShaftMining, 5), new AITarget((IAIState)AIWorkerState.MINER_BUILDING_SHAFT, this::doShaftBuilding, 5), new AITarget((IAIState)AIWorkerState.MINER_MINING_NODE, this::executeNodeMining, 5));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getStrength() + this.worker.getCitizenData().getEndurance());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingMiner.class;
    }

    @NotNull
    private IAIState startWorkingAtOwnBuilding() {
        if (this.worker.getPosY() >= (double)this.getOwnBuilding().getPosition().func_177956_o() && this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        return AIWorkerState.PREPARING;
    }

    @Override
    public BuildingMiner getOwnBuilding() {
        return this.getOwnBuilding(BuildingMiner.class);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return this.getOwnBuilding().getBuildingLevel() * 64;
    }

    @Override
    protected void updateRenderMetaData() {
        String renderMetaData = this.getRenderMetaTorch();
        this.worker.setRenderMetadata(renderMetaData);
    }

    @NotNull
    private String getRenderMetaTorch() {
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Blocks.field_150478_aa, -1)) {
            return RENDER_META_TORCH;
        }
        return "";
    }

    @NotNull
    private IAIState prepareForMining() {
        if (this.getOwnBuilding() != null && !this.getOwnBuilding().hasFoundLadder()) {
            return AIWorkerState.MINER_SEARCHING_LADDER;
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    @NotNull
    private IAIState goToLadder() {
        if (this.walkToLadder()) {
            return AIWorkerState.MINER_WALKING_TO_LADDER;
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private boolean walkToLadder() {
        return this.walkToBlock(this.getOwnBuilding().getLadderLocation());
    }

    @NotNull
    private IAIState checkMineShaft() {
        BuildingMiner buildingMiner = this.getOwnBuilding();
        if (WorkerUtil.getLastLadder(buildingMiner.getLadderLocation(), this.world) < buildingMiner.getDepthLimit()) {
            if (buildingMiner.getNumberOfLevels() == 0) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("entity.miner.messagerequiresbetterhut", new Object[0]), ChatPriority.BLOCKING));
                buildingMiner.setClearedShaft(false);
                return AIWorkerState.IDLE;
            }
            buildingMiner.setClearedShaft(true);
            return AIWorkerState.MINER_MINING_NODE;
        }
        buildingMiner.setClearedShaft(false);
        return AIWorkerState.MINER_MINING_SHAFT;
    }

    @Override
    public ItemStack getTotalAmount(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return null;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(Math.max(super.getTotalAmount(stack).func_190916_E(), copy.func_77976_d() / 2));
        return copy;
    }

    @NotNull
    private IAIState lookForLadder() {
        BuildingMiner buildingMiner = this.getOwnBuilding();
        if (buildingMiner.hasFoundLadder() && buildingMiner.getLadderLocation() != null) {
            if (this.world.func_180495_p(buildingMiner.getLadderLocation()).func_177230_c() == Blocks.field_150468_ap) {
                return AIWorkerState.MINER_WALKING_TO_LADDER;
            }
            buildingMiner.setFoundLadder(false);
            buildingMiner.setLadderLocation(null);
        }
        int posX = buildingMiner.getPosition().func_177958_n();
        int posY = buildingMiner.getPosition().func_177956_o() + 2;
        int posZ = buildingMiner.getPosition().func_177952_p();
        for (int y = posY - 10; y < posY; ++y) {
            for (int x = posX - 10; x < posX + 10; ++x) {
                for (int z = posZ - 10; z < posZ + 10; ++z) {
                    this.tryFindLadderAt(new BlockPos(x, y, z));
                }
            }
        }
        return AIWorkerState.MINER_SEARCHING_LADDER;
    }

    private void tryFindLadderAt(@NotNull BlockPos pos) {
        BuildingMiner buildingMiner = this.getOwnBuilding();
        if (buildingMiner.hasFoundLadder()) {
            return;
        }
        if (this.world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150468_ap)) {
            int firstLadderY = this.getFirstLadder(pos);
            buildingMiner.setLadderLocation(new BlockPos(pos.func_177958_n(), firstLadderY, pos.func_177952_p()));
            this.validateLadderOrientation();
        }
    }

    private void validateLadderOrientation() {
        BuildingMiner buildingMiner = this.getOwnBuilding();
        EnumFacing ladderOrientation = (EnumFacing)this.world.func_180495_p(buildingMiner.getLadderLocation()).func_177229_b((IProperty)BlockLadder.field_176382_a);
        if (ladderOrientation == EnumFacing.WEST) {
            buildingMiner.setVectorX(-1);
            buildingMiner.setVectorZ(0);
        } else if (ladderOrientation == EnumFacing.EAST) {
            buildingMiner.setVectorX(1);
            buildingMiner.setVectorZ(0);
        } else if (ladderOrientation == EnumFacing.SOUTH) {
            buildingMiner.setVectorX(0);
            buildingMiner.setVectorZ(1);
        } else if (ladderOrientation == EnumFacing.NORTH) {
            buildingMiner.setVectorX(0);
            buildingMiner.setVectorZ(-1);
        } else {
            throw new IllegalStateException("Ladder metadata was " + ladderOrientation);
        }
        int x = buildingMiner.getLadderLocation().func_177958_n();
        int y = buildingMiner.getLadderLocation().func_177956_o();
        int z = buildingMiner.getLadderLocation().func_177952_p();
        buildingMiner.setCobbleLocation(new BlockPos(x - buildingMiner.getVectorX(), y, z - buildingMiner.getVectorZ()));
        buildingMiner.setShaftStart(new BlockPos(x, WorkerUtil.getLastLadder(buildingMiner.getLadderLocation(), this.world) - 1, z));
        buildingMiner.setFoundLadder(true);
    }

    private IAIState doShaftMining() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.mining", new Object[0])});
        this.minerWorkingLocation = this.getNextBlockInShaftToMine();
        if (this.minerWorkingLocation == null) {
            return this.advanceLadder(AIWorkerState.MINER_MINING_SHAFT);
        }
        if (this.mineBlock(this.minerWorkingLocation, this.currentStandingPosition)) {
            this.worker.decreaseSaturationForContinuousAction();
        }
        return AIWorkerState.MINER_MINING_SHAFT;
    }

    @Override
    protected void triggerMinedBlock(@NotNull IBlockState blockToMine) {
        super.triggerMinedBlock(blockToMine);
        if (IColonyManager.getInstance().getCompatibilityManager().isLuckyBlock(new ItemStack(blockToMine.func_177230_c()))) {
            InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(IColonyManager.getInstance().getCompatibilityManager().getRandomLuckyOre(), (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
        }
    }

    private IAIState advanceLadder(IAIState state) {
        if (this.getOwnBuilding().getStartingLevelShaft() > 4) {
            return AIWorkerState.MINER_BUILDING_SHAFT;
        }
        if (!this.checkIfRequestForItemExistOrCreate(new ItemStack(Blocks.field_150347_e, 32), new ItemStack(Blocks.field_150468_ap, 10))) {
            return state;
        }
        BlockPos safeCobble = new BlockPos(this.getOwnBuilding().getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(this.getOwnBuilding().getLadderLocation(), this.world) - 2, this.getOwnBuilding().getLadderLocation().func_177952_p());
        int xOffset = 3 * this.getOwnBuilding().getVectorX();
        int zOffset = 3 * this.getOwnBuilding().getVectorZ();
        for (int x = -5 + xOffset; x <= 5 + xOffset; ++x) {
            for (int z = -5 + zOffset; z <= 5 + zOffset; ++z) {
                BlockPos curBlock = new BlockPos(safeCobble.func_177958_n() + x, safeCobble.func_177956_o(), safeCobble.func_177952_p() + z);
                if (this.secureBlock(curBlock, this.currentStandingPosition)) continue;
                return state;
            }
        }
        BlockPos safeStand = new BlockPos(this.getOwnBuilding().getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(this.getOwnBuilding().getLadderLocation(), this.world), this.getOwnBuilding().getLadderLocation().func_177952_p());
        BlockPos nextLadder = new BlockPos(this.getOwnBuilding().getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(this.getOwnBuilding().getLadderLocation(), this.world) - 1, this.getOwnBuilding().getLadderLocation().func_177952_p());
        BlockPos nextCobble = new BlockPos(this.getOwnBuilding().getCobbleLocation().func_177958_n(), WorkerUtil.getLastLadder(this.getOwnBuilding().getLadderLocation(), this.world) - 1, this.getOwnBuilding().getCobbleLocation().func_177952_p());
        if (!this.mineBlock(nextCobble, safeStand) || !this.mineBlock(nextLadder, safeStand)) {
            return state;
        }
        IBlockState metadata = this.getBlockState(safeStand);
        this.setBlockFromInventory(nextCobble, Blocks.field_150347_e);
        this.setBlockFromInventory(nextLadder, Blocks.field_150468_ap, metadata);
        this.getOwnBuilding().incrementStartingLevelShaft();
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private IBlockState getBlockState(@NotNull BlockPos pos) {
        return this.world.func_180495_p(pos);
    }

    @Nullable
    private BlockPos getNextBlockInShaftToMine() {
        double distance;
        BlockPos curBlock;
        int z;
        int x;
        Block block;
        BlockPos ladderPos = this.getOwnBuilding().getLadderLocation();
        int lastLadder = WorkerUtil.getLastLadder(ladderPos, this.world);
        if (this.minerWorkingLocation == null) {
            this.minerWorkingLocation = new BlockPos(ladderPos.func_177958_n(), lastLadder + 1, ladderPos.func_177952_p());
        }
        if ((block = this.getBlock(this.minerWorkingLocation)) != null && block != Blocks.field_150350_a && block != Blocks.field_150468_ap && !block.equals(Blocks.field_150358_i) && !block.equals(Blocks.field_150356_k)) {
            return this.minerWorkingLocation;
        }
        this.currentStandingPosition = this.minerWorkingLocation;
        BlockPos nextBlockToMine = null;
        double bestDistance = Double.MAX_VALUE;
        int xOffset = 3 * this.getOwnBuilding().getVectorX();
        int zOffset = 3 * this.getOwnBuilding().getVectorZ();
        for (x = 3 + xOffset + 2; x >= -3 + xOffset - 2; --x) {
            for (z = -3 + zOffset - 2; z <= 3 + zOffset + 2; ++z) {
                if (x == 0 && 0 == z || !(block = this.getBlock(curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder, ladderPos.func_177952_p() + z))).equals(Blocks.field_150355_j) && !block.equals(Blocks.field_150353_l) && !block.equals(Blocks.field_150358_i) && !block.equals(Blocks.field_150356_k)) continue;
                this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
            }
        }
        for (x = 3 + xOffset; x >= -3 + xOffset; --x) {
            for (z = -3 + zOffset; z <= 3 + zOffset; ++z) {
                if (x == 0 && 0 == z) continue;
                curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder, ladderPos.func_177952_p() + z);
                distance = curBlock.func_177951_i((Vec3i)ladderPos) + Math.pow(curBlock.func_177951_i((Vec3i)this.minerWorkingLocation), 2.0);
                block = this.getBlock(curBlock);
                if (!(distance < bestDistance) || this.world.func_175623_d(curBlock)) continue;
                if (block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150353_l) || block.equals(Blocks.field_150358_i) || block.equals(Blocks.field_150356_k)) {
                    this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
                }
                nextBlockToMine = curBlock;
                bestDistance = distance;
            }
        }
        bestDistance = Double.MAX_VALUE;
        if (nextBlockToMine != null) {
            for (x = 1; x >= -1; --x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && 0 == z || !((distance = (curBlock = new BlockPos(nextBlockToMine.func_177958_n() + x, lastLadder, nextBlockToMine.func_177952_p() + z)).func_177951_i((Vec3i)ladderPos)) < bestDistance) || !this.world.func_175623_d(curBlock)) continue;
                    this.currentStandingPosition = curBlock;
                    bestDistance = distance;
                }
            }
        }
        return nextBlockToMine;
    }

    @NotNull
    private IAIState doShaftBuilding() {
        if (this.walkToBuilding()) {
            return AIWorkerState.MINER_BUILDING_SHAFT;
        }
        BlockPos ladderPos = this.getOwnBuilding().getLadderLocation();
        int lastLadder = WorkerUtil.getLastLadder(ladderPos, this.world) + 1;
        int xOffset = 3 * this.getOwnBuilding().getVectorX();
        int zOffset = 3 * this.getOwnBuilding().getVectorZ();
        this.initStructure(null, 0, new BlockPos(ladderPos.func_177958_n() + xOffset, lastLadder + 1, ladderPos.func_177952_p() + zOffset));
        return AIWorkerState.CLEAR_STEP;
    }

    @NotNull
    private IAIState executeNodeMining() {
        Level currentLevel = this.getOwnBuilding().getCurrentLevel();
        if (currentLevel == null) {
            Log.getLogger().warn("Current Level not set, resetting...");
            this.getOwnBuilding().setCurrentLevel(this.getOwnBuilding().getNumberOfLevels() - 1);
            return this.executeNodeMining();
        }
        return this.searchANodeToMine(currentLevel);
    }

    private IAIState searchANodeToMine(@NotNull Level currentLevel) {
        BlockPos standingPosition;
        int vectorZ;
        BuildingMiner buildingMiner = this.getOwnBuilding(BuildingMiner.class);
        if (buildingMiner == null) {
            return AIWorkerState.IDLE;
        }
        if (this.workingNode == null || this.workingNode.getStatus() == Node.NodeStatus.COMPLETED) {
            this.workingNode = buildingMiner.getActiveNode();
            buildingMiner.setActiveNode(this.workingNode);
            return AIWorkerState.MINER_CHECK_MINESHAFT;
        }
        int rotation = 0;
        int workingNodeX = this.workingNode.getX() > this.workingNode.getParent().getX() ? 1 : 0;
        int workingNodeZ = this.workingNode.getZ() > this.workingNode.getParent().getZ() ? 1 : 0;
        int vectorX = this.workingNode.getX() < this.workingNode.getParent().getX() ? -1 : workingNodeX;
        int n = vectorZ = this.workingNode.getZ() < this.workingNode.getParent().getZ() ? -1 : workingNodeZ;
        if (vectorX == -1) {
            rotation = 2;
        } else if (vectorZ == -1) {
            rotation = 3;
        } else if (vectorZ == 1) {
            rotation = 1;
        }
        Node parentNode = currentLevel.getNode(this.workingNode.getParent());
        if (parentNode != null && parentNode.getStyle() != Node.NodeType.SHAFT && (parentNode.getStatus() != Node.NodeStatus.COMPLETED || this.world.func_180495_p(new BlockPos(parentNode.getX(), currentLevel.getDepth() + 2, parentNode.getZ())).func_177230_c() != Blocks.field_150350_a)) {
            this.workingNode = parentNode;
            this.workingNode.setStatus(Node.NodeStatus.AVAILABLE);
            buildingMiner.setActiveNode(parentNode);
        }
        this.currentStandingPosition = standingPosition = new BlockPos(this.workingNode.getParent().getX(), currentLevel.getDepth(), this.workingNode.getParent().getZ());
        if (!(this.workingNode.getStatus() != Node.NodeStatus.AVAILABLE && this.workingNode.getStatus() != Node.NodeStatus.IN_PROGRESS || this.walkToBlock(standingPosition))) {
            return this.executeStructurePlacement(this.workingNode, standingPosition, rotation);
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private boolean secureBlock(@NotNull BlockPos curBlock, @NotNull BlockPos safeStand) {
        if (!this.getBlockState(curBlock).func_185904_a().func_76230_c() && this.getBlock(curBlock) != Blocks.field_150478_aa || IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.func_180495_p(curBlock))) {
            if (!this.mineBlock(curBlock, safeStand)) {
                this.setDelay(1);
                return false;
            }
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack(Blocks.field_150347_e, 32))) {
                return false;
            }
            this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
            return false;
        }
        return true;
    }

    private void initStructure(Node mineNode, int rotateTimes, BlockPos structurePos) {
        String style = this.getOwnBuilding().getStyle();
        String requiredName = null;
        int rotateCount = 0;
        if (mineNode == null) {
            rotateCount = this.getRotationFromVector();
            requiredName = this.getCorrectStyleLocation(style, MAIN_SHAFT_NAME);
        } else {
            rotateCount = rotateTimes;
            if (mineNode.getStyle() == Node.NodeType.CROSSROAD) {
                requiredName = this.getCorrectStyleLocation(style, X4_SHAFT_NAME);
            } else if (mineNode.getStyle() == Node.NodeType.BEND) {
                requiredName = this.getCorrectStyleLocation(style, X2_RIGHT_SHAFT_NAME);
            } else if (mineNode.getStyle() == Node.NodeType.TUNNEL) {
                requiredName = this.getCorrectStyleLocation(style, X2_TOP_SHAFT_NAME);
            }
        }
        if (requiredName != null) {
            if (((JobMiner)this.job).getWorkOrder() == null) {
                WorkOrderBuildMiner wo = new WorkOrderBuildMiner(requiredName, requiredName, rotateCount, structurePos, false, this.getOwnBuilding().getPosition());
                this.worker.getCitizenColonyHandler().getColony().getWorkManager().addWorkOrder(wo, false);
                ((JobMiner)this.job).setWorkOrder(wo);
                this.initiate();
            } else if (this.currentStructure == null) {
                this.initiate();
            }
        }
    }

    private String getCorrectStyleLocation(String style, String shaft) {
        Structure wrapper = new Structure(this.world, "schematics/" + style + shaft, new PlacementSettings());
        if (wrapper.getBluePrint() != null) {
            return "schematics/" + style + shaft;
        }
        return "schematics" + shaft;
    }

    private int getRotationFromVector() {
        if (this.getOwnBuilding().getVectorX() == 1) {
            return 1;
        }
        if (this.getOwnBuilding().getVectorZ() == 1) {
            return 2;
        }
        if (this.getOwnBuilding().getVectorX() == -1) {
            return 3;
        }
        if (this.getOwnBuilding().getVectorZ() == -1) {
            return 4;
        }
        return 0;
    }

    private IAIState executeStructurePlacement(@NotNull Node mineNode, @NotNull BlockPos standingPosition, int rotation) {
        mineNode.setStatus(Node.NodeStatus.IN_PROGRESS);
        if (((JobMiner)this.job).getStructure() == null) {
            this.initStructure(mineNode, rotation, new BlockPos(mineNode.getX(), this.getOwnBuilding().getCurrentLevel().getDepth(), mineNode.getZ()));
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                for (int y = -1; y <= 5; ++y) {
                    BlockPos curBlock = new BlockPos(mineNode.getX() + x, standingPosition.func_177956_o() + y, mineNode.getZ() + z);
                    Block block = this.getBlock(curBlock);
                    if (!block.equals(Blocks.field_150355_j) && !block.equals(Blocks.field_150353_l) && !block.equals(Blocks.field_150358_i) && !block.equals(Blocks.field_150356_k)) continue;
                    this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
                }
            }
        }
        this.workingNode = null;
        if (((JobMiner)this.job).getStructure() != null) {
            this.onStartWithoutStructure();
            return AIWorkerState.CLEAR_STEP;
        }
        return AIWorkerState.MINER_MINING_NODE;
    }

    private void setBlockFromInventory(@NotNull BlockPos location, @NotNull Block block) {
        this.worker.func_184609_a(this.worker.func_184600_cs());
        this.setBlockFromInventory(location, block, block.func_176223_P());
    }

    private void setBlockFromInventory(@NotNull BlockPos location, Block block, IBlockState metadata) {
        int slot = block instanceof BlockLadder ? this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block, -1) : this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block, block.func_176201_c(metadata));
        if (slot != -1) {
            new InvWrapper((IInventory)this.getInventory()).extractItem(slot, 1, false);
            this.world.func_180501_a(location, metadata, 3);
        }
    }

    private Block getBlock(@NotNull BlockPos loc) {
        return this.world.func_180495_p(loc).func_177230_c();
    }

    private int getFirstLadder(@NotNull BlockPos pos) {
        if (this.world.func_180495_p(pos).func_177230_c().isLadder(this.world.func_180495_p(pos), (IBlockAccess)this.world, pos, (EntityLivingBase)this.worker)) {
            return this.getFirstLadder(pos.func_177984_a());
        }
        return pos.func_177956_o() - 1;
    }

    @Override
    public void executeSpecificCompleteActions() {
        List<WorkOrderBuildMiner> workOrders;
        BuildingMiner minerBuilding = this.getOwnBuilding();
        if (minerBuilding.hasClearedShaft()) {
            Level currentLevel = minerBuilding.getCurrentLevel();
            currentLevel.closeNextNode(this.getRotation(), this.getOwnBuilding().getActiveNode());
            this.getOwnBuilding(BuildingMiner.class).setActiveNode(null);
            this.getOwnBuilding(BuildingMiner.class).setOldNode(this.workingNode);
            WorkerUtil.updateLevelSign(this.world, currentLevel, minerBuilding.getLevelId(currentLevel));
        } else if (((JobMiner)this.job).getStructure() != null) {
            BlockPos levelSignPos = WorkerUtil.findFirstLevelSign(((JobMiner)this.job).getStructure());
            Level currentLevel = new Level(minerBuilding, ((JobMiner)this.job).getStructure().getPosition().func_177956_o(), levelSignPos);
            minerBuilding.addLevel(currentLevel);
            minerBuilding.setCurrentLevel(minerBuilding.getNumberOfLevels());
            minerBuilding.resetStartingLevelShaft();
            WorkerUtil.updateLevelSign(this.world, currentLevel, minerBuilding.getLevelId(currentLevel));
        }
        super.executeSpecificCompleteActions();
        this.getOwnBuilding().markDirty();
        ((JobMiner)this.job).setStructure(null);
        IColony colony = this.worker.getCitizenColonyHandler().getColony();
        if (colony != null && (workOrders = colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildMiner.class)).size() > 2) {
            for (WorkOrderBuildMiner order : workOrders) {
                if (!this.getOwnBuilding().getID().equals((Object)order.getMinerBuilding())) continue;
                colony.getWorkManager().removeWorkOrder(order.getID());
            }
        }
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return this.getNodeMiningPosition(targetPosition);
    }

    private BlockPos getNodeMiningPosition(BlockPos blockToMine) {
        BuildingMiner buildingMiner = this.getOwnBuilding();
        if (buildingMiner.getCurrentLevel() == null || buildingMiner.getActiveNode() == null) {
            return blockToMine;
        }
        Vec2i parentPos = buildingMiner.getActiveNode().getParent();
        if (parentPos != null && buildingMiner.getCurrentLevel().getNode(parentPos) != null && buildingMiner.getCurrentLevel().getNode(parentPos).getStyle() == Node.NodeType.SHAFT) {
            BlockPos ladderPos = buildingMiner.getLadderLocation();
            return new BlockPos(ladderPos.func_177958_n() + buildingMiner.getVectorX() * 6, buildingMiner.getCurrentLevel().getDepth(), ladderPos.func_177952_p() + buildingMiner.getVectorZ() * 6);
        }
        Vec2i pos = buildingMiner.getActiveNode().getParent();
        return new BlockPos(pos.getX(), buildingMiner.getCurrentLevel().getDepth(), pos.getZ());
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, IBlockState worldMetadata) {
        return IColonyManager.getInstance().getCompatibilityManager().isOre(worldMetadata);
    }

    @Override
    public IBlockState getSolidSubstitution(BlockPos ignored) {
        return Blocks.field_150347_e.func_176223_P();
    }

    @Override
    protected boolean checkIfCanceled() {
        if (super.checkIfCanceled()) {
            return true;
        }
        if (!this.isThereAStructureToBuild()) {
            switch ((AIWorkerState)this.getState()) {
                case CLEAR_STEP: 
                case BUILDING_STEP: 
                case DECORATION_STEP: 
                case SPAWN_STEP: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

