/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAICrafting<J extends AbstractJobCrafter>
extends AbstractEntityAIInteract<J> {
    protected static final int HIT_DELAY = 20;
    public static final int PROGRESS_MULTIPLIER = 10;
    protected static final int MAX_LEVEL = 50;
    private static final int HITTING_TIME = 3;
    public IRequest<? extends PublicCrafting> currentRequest;
    protected IRecipeStorage currentRecipeStorage;

    public AbstractEntityAICrafting(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::decide, 5), new AITarget((IAIState)AIWorkerState.QUERY_ITEMS, this::queryItems, 5), new AITarget((IAIState)AIWorkerState.GET_RECIPE, this::getRecipe, 5), new AITarget((IAIState)AIWorkerState.CRAFT, this::craft, 20));
        this.worker.func_98053_h(true);
    }

    protected IAIState decide() {
        if (((AbstractJobCrafter)this.job).getTaskQueue().isEmpty()) {
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getActionsDone() > 0) {
            return this.getState();
        }
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    private IAIState getRecipe() {
        IRequest currentTask = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (currentTask == null) {
            return AIWorkerState.START_WORKING;
        }
        Object buildingWorker = this.getOwnBuilding();
        this.currentRecipeStorage = buildingWorker.getFirstFullFillableRecipe(((PublicCrafting)currentTask.getRequest()).getStack());
        if (this.currentRecipeStorage == null) {
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        this.currentRequest = currentTask;
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(this.currentRequest.getRequest().getCount());
        return AIWorkerState.QUERY_ITEMS;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.GET_RECIPE;
    }

    private IAIState queryItems() {
        if (this.currentRecipeStorage == null) {
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        return this.checkForItems(this.currentRecipeStorage);
    }

    protected IAIState checkForItems(@NotNull IRecipeStorage storage) {
        List<ItemStorage> input = storage.getCleanedInput();
        for (ItemStorage inputStorage : input) {
            Predicate<ItemStack> predicate = stack -> ItemStackUtils.isEmpty(stack) == false && new Stack((ItemStack)stack).matches(inputStorage.getItemStack());
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), predicate) >= inputStorage.getAmount()) continue;
            if (InventoryUtils.hasItemInProvider(this.getOwnBuilding(), predicate)) {
                this.needsCurrently = predicate;
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            return AIWorkerState.GET_RECIPE;
        }
        return AIWorkerState.CRAFT;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected IAIState craft() {
        if (this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentRequest == null) {
            return AIWorkerState.GET_RECIPE;
        }
        if (this.walkToBuilding()) {
            return this.getState();
        }
        ((AbstractJobCrafter)this.job).setProgress(((AbstractJobCrafter)this.job).getProgress() + 1);
        this.worker.func_184611_a(EnumHand.MAIN_HAND, this.currentRecipeStorage.getCleanedInput().get(this.worker.getRandom().nextInt(this.currentRecipeStorage.getCleanedInput().size())).getItemStack().func_77946_l());
        this.worker.func_184611_a(EnumHand.OFF_HAND, this.currentRecipeStorage.getPrimaryOutput().func_77946_l());
        this.worker.getCitizenItemHandler().hitBlockWithToolInHand(((AbstractSchematicProvider)this.getOwnBuilding()).getPosition());
        this.currentRequest = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (this.currentRequest != null && this.currentRequest.getState() == RequestState.CANCELLED) {
            this.currentRequest = null;
            this.incrementActionsDone();
            this.currentRecipeStorage = null;
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getProgress() < this.getRequiredProgressForMakingRawMaterial()) return this.getState();
        IAIState check = this.checkForItems(this.currentRecipeStorage);
        if (check != AIWorkerState.CRAFT) {
            this.currentRequest = null;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDoneAndDecSaturation();
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        if (!this.currentRecipeStorage.fullFillRecipe(this.worker.getItemHandlerCitizen())) {
            this.currentRequest = null;
            this.incrementActionsDone();
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        this.currentRequest.addDelivery(this.currentRecipeStorage.getPrimaryOutput());
        ((AbstractJobCrafter)this.job).setCraftCounter(((AbstractJobCrafter)this.job).getCraftCounter() + 1);
        if (((AbstractJobCrafter)this.job).getCraftCounter() >= ((AbstractJobCrafter)this.job).getMaxCraftingCount()) {
            this.incrementActionsDone();
            this.currentRecipeStorage = null;
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        ((AbstractJobCrafter)this.job).setProgress(0);
        return AIWorkerState.GET_RECIPE;
    }

    public void resetValues() {
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(0);
        ((AbstractJobCrafter)this.job).setProgress(0);
        ((AbstractJobCrafter)this.job).setCraftCounter(0);
        this.worker.func_184611_a(EnumHand.MAIN_HAND, ItemStackUtils.EMPTY);
        this.worker.func_184611_a(EnumHand.OFF_HAND, ItemStackUtils.EMPTY);
    }

    @Override
    public IAIState afterDump() {
        if (((AbstractJobCrafter)this.job).getMaxCraftingCount() == 0 && ((AbstractJobCrafter)this.job).getProgress() == 0 && ((AbstractJobCrafter)this.job).getCraftCounter() == 0 && this.currentRequest != null) {
            ((AbstractJobCrafter)this.job).finishRequest(true);
            this.worker.getCitizenExperienceHandler().addExperience((double)this.currentRequest.getRequest().getCount() / 2.0);
            this.currentRequest = null;
        }
        this.resetValues();
        ((AbstractBuildingContainer)this.getOwnBuilding()).setPickUpPriority(1);
        return super.afterDump();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private int getRequiredProgressForMakingRawMaterial() {
        return 10 / Math.min(this.worker.getCitizenExperienceHandler().getLevel() + 1, 50) * 3;
    }
}

