/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class SetHappinessLevelColonyCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "shl";
    private static final String DELETE_COLONY_CONFIRM_DELETE_COMMAND_SUGGESTED = "/mc colony shl colony: %d level: %d";

    public SetHappinessLevelColonyCommand() {
        super(new String[0]);
    }

    public SetHappinessLevelColonyCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId|OwnerName>";
    }

    @Override
    public boolean canRankUseCommand(@NotNull IColony colony, @NotNull EntityPlayer player) {
        return colony.getPermissions().getRank(player).equals((Object)Rank.OWNER);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        IColony colony = actionMenuState.getColonyForArgument("colony");
        Optional<Double> level = Optional.ofNullable(actionMenuState.getDoubleForArgument("level"));
        if (colony == null) {
            String noColonyFoundMessage = String.format("Invalid colony, aborting!", new Object[0]);
            sender.func_145747_a((ITextComponent)new TextComponentString(noColonyFoundMessage));
            return;
        }
        this.executeShared(server, sender, colony, level);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        int dimensionId;
        int colonyId;
        IColony colony;
        Optional<Double> level = Optional.empty();
        if (args.length == 0) {
            colony = null;
            if (sender instanceof EntityPlayer) {
                colony = IColonyManager.getInstance().getIColonyByOwner(CompatibilityUtils.getWorldFromEntity((Entity)((EntityPlayer)sender)), (EntityPlayer)sender);
            }
            if (colony == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid colony, aborting!"));
                return;
            }
            colonyId = colony.getID();
            dimensionId = colony.getDimension();
        } else {
            colonyId = SetHappinessLevelColonyCommand.getColonyIdFromArg(args, 0, -1);
            dimensionId = SetHappinessLevelColonyCommand.getDimensionIdFromArg(args, 0, sender.func_130014_f_().field_73011_w.getDimension());
            if (args.length > 1) {
                level = Optional.of(Double.parseDouble(args[1]));
            }
        }
        colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (World)server.func_71218_a(dimensionId));
        if (colony == null) {
            String noColonyFoundMessage = String.format("Couldn't find colony %d.", colonyId);
            sender.func_145747_a((ITextComponent)new TextComponentString(noColonyFoundMessage));
            return;
        }
        this.executeShared(server, sender, colony, level);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, IColony colony, Optional<Double> level) throws CommandException {
        colony.getColonyHappinessManager().setLockedHappinessModifier(level);
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && SetHappinessLevelColonyCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

