/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.EntityAIKnight;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;

public class JobKnight
extends AbstractJobGuard {
    public static final String DESC = "com.minecolonies.coremod.job.Knight";

    public JobKnight(ICitizenData entity) {
        super(entity);
    }

    @Override
    public AbstractEntityAIGuard generateGuardAI() {
        return new EntityAIKnight(this);
    }

    @Override
    public void onLevelUp(int newLevel) {
        if (this.getCitizen().getCitizenEntity().isPresent()) {
            AbstractEntityCitizen citizen = this.getCitizen().getCitizenEntity().get();
            AttributeModifier healthModLevel = new AttributeModifier("MinecoloniesGuardLevelHealth", (double)(this.getCitizen().getLevel() / 3 + 5), 0);
            AttributeModifierUtils.addHealthModifier((EntityLivingBase)citizen, healthModLevel);
        }
    }

    @Override
    public JobEntry getJobRegistryEntry() {
        return ModJobs.knight;
    }

    @Override
    public String getName() {
        return DESC;
    }

    @Override
    public BipedModelType getModel() {
        return BipedModelType.KNIGHT_GUARD;
    }
}

