/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.ldtteam.structures.helpers.Structure;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJobStructure
extends AbstractJob {
    private static final String TAG_WORK_ORDER = "workorder";
    private int workOrderId;
    protected Structure structure;

    public AbstractJobStructure(ICitizenData entity) {
        super(entity);
    }

    public boolean hasStructure() {
        return this.structure != null;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    public int getWorkOrderId() {
        return this.workOrderId;
    }

    public boolean hasWorkOrder() {
        return this.workOrderId != 0;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        if (this.workOrderId != 0) {
            compound.func_74768_a(TAG_WORK_ORDER, this.workOrderId);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        if (compound.func_74764_b(TAG_WORK_ORDER)) {
            this.workOrderId = compound.func_74762_e(TAG_WORK_ORDER);
        }
    }

    public void complete() {
        this.getWorkOrder().onCompleted(this.getCitizen().getColony());
        this.getCitizen().getColony().getWorkManager().removeWorkOrder(this.workOrderId);
        this.setWorkOrder(null);
        this.setStructure(null);
        this.getColony().getStatsManager().incrementStatistic("huts");
    }

    public WorkOrderBuildDecoration getWorkOrder() {
        return this.getColony().getWorkManager().getWorkOrder(this.workOrderId, WorkOrderBuildDecoration.class);
    }

    private void resetNeededItems() {
        IBuildingWorker workerBuilding = this.getCitizen().getWorkBuilding();
        if (workerBuilding instanceof BuildingBuilder) {
            ((BuildingBuilder)workerBuilding).resetNeededResources();
        }
    }

    public void setWorkOrder(@Nullable WorkOrderBuildDecoration order) {
        if (order == null) {
            this.workOrderId = 0;
            this.resetNeededItems();
        } else {
            this.workOrderId = order.getID();
        }
    }
}

